<?php
/**
 * Include and setup custom metaboxes and fields. (make sure you copy this file to outside the CMB2 directory)
 *
 * Be sure to replace all instances of 'yourprefix_' with your project's prefix.
 * http://nacin.com/2010/05/11/in-wordpress-prefix-everything/
 *
 * @category YourThemeOrPlugin
 * @package  Demo_CMB2
 * @license  http://www.opensource.org/licenses/gpl-license.php GPL v2.0 (or later)
 * @link     https://github.com/WebDevStudios/CMB2
 */


/* CMB2 Meta Box */
add_action( 'cmb2_init', 'ova_dir_metaboxes' );
function ova_dir_metaboxes() {

    // Start with an underscore to hide fields from custom fields list
    $prefix = 'ova_dir_met_';
    
    $dir_settings = new_cmb2_box( array(
        'id'            => 'ovadir_settings',
        'title'         => esc_html__( 'Directory settings', 'ova-dir' ),
        'object_types'  => array( 'ova_dir'), // Post type
        'context'       => 'normal',
        'priority'      => 'high',
        'show_names'    => true,
        
    ) );

    $dir_contact_group_field_id = $dir_settings->add_field( array(
        'id'          => 'ova_dir_contact_group',
        'type'        => 'group',
        'options'     => array(
            'group_title'       => esc_html__( 'Contact', 'ova-dir' ),
            'add_button'        => esc_html__( 'Add Contact', 'ova-dir' ),
            'remove_button'     => esc_html__( 'Remove Contact', 'ova-dir' ),
            'sortable'          => true,
        ),
    ) );

    $dir_settings->add_group_field( $dir_contact_group_field_id, array(
        'name' => esc_html__('Class Icon', 'ova-dir'),
        'id'   => $prefix . 'contact_icon',
        'type' => 'text',
    ) );

    $dir_settings->add_group_field( $dir_contact_group_field_id, array(
        'name' => esc_html__('Label', 'ova-dir'),
        'id'   => $prefix . 'contact_label',
        'type' => 'text',
    ) );

    $dir_settings->add_group_field( $dir_contact_group_field_id, array(
        'name' => esc_html__( 'Link', 'ova-dir' ),
        'id'   => $prefix . 'contact_link',
        'type' => 'text_url',
    ) );

    /* Opening hours */
    $dir_opening_group_field_id = $dir_settings->add_field( array(
        'id'          => 'ova_dir_opening_group',
        'type'        => 'group',
        'options'     => array(
            'group_title'       => esc_html__( 'Opening hours', 'ova-dir' ),
            'add_button'        => esc_html__( 'Add Opening Hours', 'ova-dir' ),
            'remove_button'     => esc_html__( 'Remove Opening Hours', 'ova-dir' ),
            'sortable'          => true,
        ),
    ) );

    $dir_settings->add_group_field( $dir_opening_group_field_id, array(
        'name' => esc_html__('Day of the week', 'ova-dir'),
        'id'   => $prefix . 'opening_day',
        'type' => 'text',
    ) );

    $dir_settings->add_group_field( $dir_opening_group_field_id,array(
        'name' => esc_html__('Opening hours', 'ova-dir'),
        'id' => $prefix . 'opening_hours',
        'type' => 'text_time',
    ) );

    $dir_settings->add_group_field( $dir_opening_group_field_id,array(
        'name' => esc_html__('Closing hours', 'ova-dir'),
        'id' => $prefix . 'closing_hours',
        'type' => 'text_time',
    ) );

    // short address
    $dir_settings->add_field( array(
        'name'    => esc_html__( 'Short Address', 'ova-dir' ),
        'id'      => $prefix . 'short_address',
        'type'    => 'text',
        'description' => esc_html__( 'Display short address instead of address in google map', 'ova-dir' ),
    ) );

    if( get_theme_mod('ova_dir_use_google_map','yes') == 'yes' ) {
        $dir_settings->add_field( array(
            'name'    => esc_html__( 'Map Marker', 'ova-dir' ),
            'id'      => $prefix . 'marker_img',
            'type'    => 'file',
            'description' => esc_html__( 'Display custom image for markers', 'ova-dir' ),
            'options' => array(
                'url' => false,
            ),
            'text'    => array(
                'add_upload_file_text' => esc_html__( 'Add image', 'ova-dir' )
            ),
         
            'preview_size' => array( 50, 50 ),
        ) );
    }
}


/* Ova Google Map Meta Box */
if( get_theme_mod('ova_dir_use_google_map','yes') == 'yes' ) {
    class Ova_Dir_Meta_Box {
        public function __construct(){
            add_action( 'add_meta_boxes', array( $this, 'ova_dir_add_metaboxes' ) );
            add_action( 'save_post', array( $this, 'ova_dir_save_metaboxs' ) );
        }

        public function ova_dir_add_metaboxes(){
            add_meta_box( 'ova_dir_google_map_metabox', esc_html__('Google Map', 'ova-dir'), array($this,'ova_dir_html_metaboxs'), 'ova_dir' );
        }

        public function ova_dir_html_metaboxs( $post ){
            $address            = get_post_meta( $post->ID, 'ova_dir_met_address', true );
            $latitude           = get_post_meta( $post->ID, 'ova_dir_met_latitude', true );
            $longitude          = get_post_meta( $post->ID, 'ova_dir_met_longitude', true );
            $ova_dir_zoom       = get_theme_mod( 'ova_dir_zoom', 14 );
            $ova_dir_latitude   = get_theme_mod( 'ova_dir_latitude', 40.749933 );
            $ova_dir_longitude  = get_theme_mod( 'ova_dir_longitude', -73.98633 );
            $data_map   = array(
                'zoom'      => $ova_dir_zoom,
                'latitude'  => $ova_dir_latitude,
                'longitude' => $ova_dir_longitude
            );
            ?>
            <div class="pac-card" id="pac-card">
                <div id="pac-container">
                    <input id="pac-input" name="ova_dir_met_address" type="text" placeholder="<?php esc_attr_e( 'Enter a location', 'ova-dir' ); ?>" value="<?php echo esc_html( $address ); ?>" />
                    <input type="hidden" name="ova_dir_met_latitude" id="ova_dir_met_latitude" value="<?php echo esc_attr( $latitude ); ?>" />
                    <input type="hidden" name="ova_dir_met_longitude" id="ova_dir_met_longitude" value="<?php echo esc_attr( $longitude ); ?>" />
                </div>
            </div>
            <div id="ova_dir_map" data-map="<?php echo esc_attr( json_encode( $data_map ) ); ?>"></div>
            <div id="infowindow-content">
                <span id="place-name" class="title"></span><br />
                <span id="place-address"></span>
            </div>
            <?php
        }

        public function ova_dir_save_metaboxs($post_id){

            if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;

            if (isset($_POST['ova_dir_met_address'])) {
                update_post_meta($post_id, 'ova_dir_met_address', sanitize_text_field($_POST['ova_dir_met_address']));
            }
            if (isset($_POST['ova_dir_met_latitude'])) {
                update_post_meta($post_id, 'ova_dir_met_latitude', sanitize_text_field($_POST['ova_dir_met_latitude']));
            }
            if (isset($_POST['ova_dir_met_longitude'])) {
                update_post_meta($post_id, 'ova_dir_met_longitude', sanitize_text_field($_POST['ova_dir_met_longitude']));
            }
        }
    }

    new Ova_Dir_Meta_Box();
}