<?php if ( !defined( 'ABSPATH' ) ) exit();

	$the_query 			= ova_dir_query($args);

	$template           = $args['template'];
	$column 			= $args['number_column'];
	$term_id 			= $the_query->get_queried_object_id();
	$class_active_all 	= $term_id == 0 ? 'active' : '';

	$data_query 		= array(
		'order_by' 			=> $args['order_by'],
		'order' 			=> $args['order'],
		'posts_per_page' 	=> $args['posts_per_page'],
		'cate' 				=> $term_id,
	);

	$cate_args = array(
		'taxonomy' 	 => 'cat_dir',
		'orderby' 	 => 'name',
		'order'   	 => 'ASC',
		'hide_empty' => false,
		'exclude'    => explode( '|', $args['category_not_in'] )
	);

	$categories = get_categories($cate_args);

	// show fields
	$args_show = array(
		'show_map'   		=> $show_map,
		'show_image' 		=> $show_image,
		'show_title' 		=> $show_title,
		'show_location'	 	=> $show_location,
		'show_category' 	=> $show_category,
		'show_short_desc' 	=> isset($args['show_short_desc']) ? $args['show_short_desc'] : 'yes',
		'show_link_to'  	=> $show_link_to,
	);

?>

<div class="ova-dir-archive <?php echo esc_attr( $template ); ?> <?php echo esc_attr( $column ); ?>" 
	data-query="<?php echo esc_attr( json_encode( $data_query ) ); ?>"
	data-args_show="<?php echo esc_attr( json_encode( $args_show ) ); ?>"
>
	<?php if( $show_filter == 'yes' ): ?>
		<ul class="list-cat-dir">
			<li class="item <?php echo esc_attr( $class_active_all ); ?>">
				<a href="<?php echo esc_url( get_post_type_archive_link( 'ova_dir' ) ); ?>"
					data-id="0" class="cate_name"
				>
					<?php esc_html_e( 'All', 'ova-dir' ); ?>
				</a>
			</li>
			<?php if ( $categories ): ?>
				<?php foreach ($categories as $cate): $class_active = $term_id == $cate->term_id ? 'active' : ''; ?>
					<li class="item <?php echo esc_attr( $class_active ); ?>">
						<a href="<?php echo esc_url( get_term_link( $cate ) ); ?>"
							data-id="<?php echo esc_attr( $cate->term_id ); ?>"
							class="cate_name" title="<?php echo esc_attr( $cate->name ); ?>"
						>
							<?php echo esc_html( $cate->name ); ?>
						</a>
					</li>
				<?php endforeach; ?>
			<?php endif; ?>
		</ul>
	<?php endif; ?>

	<div class="ova-dir-loader">
		<div class="loader"></div>
	</div>

	<div class="ova_dir_archive_content">
		<?php
			ova_dir_get_items( $the_query, $args_show );
			$total_pages 	= $the_query->max_num_pages;
			$curent_page 	= 1;
			$posts_per_page = $args['posts_per_page'];
			ova_dir_pagination_ajax($total_pages,$curent_page,$posts_per_page,$data_query);
		?>
	</div>
</div>