<?php if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

	$url_bg_image = $args['background_image']['url'];

	$orderby    = isset( $args['orderby'] ) ? $args['orderby'] : 'name';
	$order      = isset( $args['order'] ) ? $args['order'] : 'ASC';
	$exclude_id = isset( $args['category_not_in'] ) ? $args['category_not_in'] : '';

	$show_icon     		= isset( $args['show_icon'] ) ? $args['show_icon'] : 'yes';
	$show_name     		= isset( $args['show_name'] ) ? $args['show_name'] : 'yes';
	$show_description   = isset( $args['show_description'] ) ? $args['show_description'] : 'yes';
	$show_link_to  		= isset( $args['show_link_to'] ) ? $args['show_link_to'] : 'yes';

    $data_options['items']              = $args['item_number'];
	$data_options['slideBy']            = $args['slides_to_scroll'];
	$data_options['margin']             = $args['margin_items'];
	$data_options['autoplayHoverPause'] = $args['pause_on_hover'] === 'yes' ? true : false;
	$data_options['loop']               = $args['infinite'] === 'yes' ? true : false;
	$data_options['autoplay']           = $args['autoplay'] === 'yes' ? true : false;
	$data_options['autoplayTimeout']    = $args['autoplay_speed'];
	$data_options['smartSpeed']         = $args['smartspeed'];
	$data_options['dots']               = $args['dot_control'] === 'yes' ? true : false;
	$data_options['nav']                = $args['nav_control'] === 'yes' ? true : false;

	$terms = get_terms( array(
	    'taxonomy'   => 'cat_career',
    	'orderby' 	 => $orderby,
		'order' 	 => $order,
		'exclude' 	 => $exclude_id,
	    'hide_empty' => false,
	) );

?>

<div class="ova-category-career-slider">

	<div class="slide-category-career owl-carousel owl-theme" data-options="<?php echo esc_attr(json_encode($data_options)) ?>">
         
        <?php foreach( $terms as $term) { 

        	$class_icon 	= get_term_meta( $term->term_id, 'class_icon', true );
			$link 			= get_term_link($term->term_id,'cat_career');
			$title 			= $term->name;
			$description 	= $term->description;

        ?>
		    <div class="item-category-career">

                <div class="mask"
                    <?php if (!empty( $url_bg_image )): ?> 
		 	    	 	style="background-image: url(<?php echo esc_attr( $url_bg_image ); ?>)"
		 	    	<?php endif;?>
                >	
                </div>

				<?php if ($show_icon == 'yes' && !empty( $class_icon ) ): ?>
	            	<div class="icon">
	            		<i aria-hidden="true" class="<?php echo esc_attr($class_icon)?>"></i>
	            	</div>
	            <?php endif;?>
                
				<?php if ($show_name == 'yes'): ?>
                	<?php if ($show_link_to == 'yes'): ?>
					<a href="<?php echo esc_url( $link ); ?> ">
					<?php endif; ?>
						<h4 class="title">
							<?php echo esc_html( $title ); ?>
						</h4>
					<?php if ($show_link_to == 'yes'): ?>
					</a>
					<?php endif; ?>
				<?php endif;?>

				<?php if (!empty( $description ) && $show_description == 'yes'): ?>
					<p class="description">
						<?php echo esc_html( $description ); ?>
					</p>
				<?php endif;?>

		    </div>

		<?php } ?>

	</div>

</div>