<?php defined( 'ABSPATH' ) || exit();

if( !class_exists( 'OVACOLL_assets' ) ){
	class OVACOLL_assets{

		public function __construct(){
			
			add_action( 'wp_enqueue_scripts', array( $this, 'ovacoll_enqueue_scripts' ), 10, 0 );

			/* Add JS for Elementor */
			add_action( 'elementor/frontend/after_register_scripts', array( $this, 'ova_enqueue_scripts_elementor_coll' ) );
		}

		public function ovacoll_enqueue_scripts(){

			if( is_post_type_archive('collection') || is_tax( 'location' ) || is_tax( 'collection_type') ){
				// Imageloaded & Masonry
				wp_enqueue_script('imagesLoaded');	
				wp_enqueue_script('masonry');

				// Select2
				wp_enqueue_style( 'select2', OVACOLL_PLUGIN_URI.'assets/libs/select2/select2.min.css' );
				wp_enqueue_script( 'select2', OVACOLL_PLUGIN_URI.'assets/libs/select2/select2.min.js', array('jquery'), null, true );

				wp_enqueue_script( 'ovacoll_script', OVACOLL_PLUGIN_URI.'assets/js/frontend/ovacoll-script.js' );
				wp_enqueue_style( 'ovacoll_style', OVACOLL_PLUGIN_URI.'assets/css/frontend/ovacoll-style.css' );

				wp_enqueue_style( 'ova-collections', OVACOLL_PLUGIN_URI.'assets/css/elementor/collections.css' );
			}	
		
			if( is_singular( 'collection' ) ){
				// Pretty Photo
				wp_enqueue_style('prettyphoto', OVACOLL_PLUGIN_URI.'assets/libs/prettyphoto/css/prettyPhoto.css');
				if ( is_ssl()) {
					wp_enqueue_script('prettyphoto', OVACOLL_PLUGIN_URI.'assets/libs/prettyphoto/jquery.prettyPhoto_https.js', array('jquery'),null,true);
				}
				else{
					wp_enqueue_script('prettyphoto', OVACOLL_PLUGIN_URI.'assets/libs/prettyphoto/jquery.prettyPhoto.js', array('jquery'),null,true);
				}

				wp_enqueue_script( 'ovacoll_script', OVACOLL_PLUGIN_URI.'assets/js/frontend/ovacoll-script.js' );
				wp_enqueue_style( 'ovacoll_style', OVACOLL_PLUGIN_URI.'assets/css/frontend/ovacoll-style.css' );	
			}

			if( is_post_type_archive('artist') || is_singular('artist') ){ 
				wp_enqueue_style( 'ovacoll_artist_style', OVACOLL_PLUGIN_URI.'assets/css/frontend/ovacoll-artist-style.css' );
			}

		}

		// Add JS for elementor
		public function ova_enqueue_scripts_elementor_coll(){
			wp_register_script( 'script-elementor-coll', OVACOLL_PLUGIN_URI. 'assets/js/script-elementor.js', [ 'jquery' ], false, true );
		}
	}

	new OVACOLL_assets();
}