<?php if ( !defined( 'ABSPATH' ) ) exit();

	get_header();

	global $post;

	$artists  = apply_filters( 'OVACOLL_artist_list', 10 );
	$selected = '';
	$search_all_artist = '';

	/* Search Collection */
	$get_search = isset( $_GET["search_collection"] ) ? $_GET["search_collection"] : '';

	if( $get_search == 'search-collection' ){
		$collections = apply_filters( 'OVACOLL_search_collection', $_REQUEST );
	} else {
		$collections = apply_filters( 'OVACOLL_collection', 10 );
	}

	$get_search_location = isset( $_GET["coll_location"] ) ? $_GET["coll_location"] : '';
	$get_search_type     = isset( $_GET["coll_type"] ) ? $_GET["coll_type"] : '';
	$get_search_artist   = isset( $_GET["coll_artist"] ) ? $_GET["coll_artist"] : '';

	if( is_tax( 'location' ) ||  get_query_var( 'location' ) != '' ){
		$get_search_location = get_query_var( 'location' );
	}

	if( is_tax( 'collection_type' ) ||  get_query_var( 'collection_type' ) != '' ){
		$get_search_type = get_query_var( 'collection_type' );
	}

	$collection_type    = isset( $_GET['collection_type'] ) ? $_GET['collection_type'] : OVACOLL_Settings::archive_collection_type();
	$collection_heading = OVACOLL_Settings::archive_collection_heading();
	$collection_desc 	= OVACOLL_Settings::archive_collection_desc();

	// show fields
	$show_search_artist   = OVACOLL_Settings::archive_collection_show_search_artist();
	$show_search_location = OVACOLL_Settings::archive_collection_show_search_location();
	$show_search_type     = OVACOLL_Settings::archive_collection_show_search_type();

	$args_show = array(
		'show_year'   => OVACOLL_Settings::archive_collection_show_year(),
		'show_type'   => OVACOLL_Settings::archive_collection_show_type(),
		'show_artist' => OVACOLL_Settings::archive_collection_show_artist(),
	);

?>

<div class="row_site">
	<div class="container_site">

		<div class="wrap_archive_masonry archive_collection_page">

			<div class="archive_collection <?php echo esc_attr($collection_type);?>">
				
				<?php if( !empty($collection_heading) || !empty($collection_desc)  ) : ?>
					<div class="heading_archive_coll">
						<?php if( !empty($collection_heading) ) : ?>
							<h1 class="title_collection second_font">
								<?php echo $collection_heading; ?>
							</h1>
						<?php endif; ?>
						<?php if( !empty($collection_desc) ) : ?>
							<p class="desc_collection second_font">
								<?php echo $collection_desc; ?>
							</p>
						<?php endif; ?>
					</div>
				<?php endif; ?>

				<?php if( $show_search_artist == 'yes' || $show_search_location == 'yes' || $show_search_type == 'yes' ) : ?>
					<div class="search_archive_coll">
						<form action="<?php echo esc_url(get_post_type_archive_link( 'collection' )) ?>" id="search_collection"
							method="GET" name="search_collection" autocomplete="off"
						>
							<?php if( $show_search_artist == 'yes' ) : ?>
								<div class="coll_artist">
									<select class="postform" name="coll_artist">
										<?php $search_all_artist .= '<option value="" '.$selected.'>'.esc_html__('All Artist', 'ova-collection').'</option>' ; ?>
										<?php if( $artists->have_posts() ): while( $artists->have_posts() ): $artists->the_post();
											$post_slug = $post->post_name;
											$selected =	$get_search_artist == $post_slug ? 'selected' : '';
											$search_all_artist .= '<option value="'.$post_slug.'" '.$selected.'>'.get_the_title().'</option>' ;
										endwhile; endif; wp_reset_postdata(); ?>
										<?php echo $search_all_artist; ?>
									</select>
								</div>
							<?php endif; ?>

							<?php if( $show_search_location == 'yes' ) : ?>
								<div class="ovacoll_location_search">
									<?php $dropdown_args = apply_filters( 'OVACOLL_location', $get_search_location ); ?>
								</div>
							<?php endif; ?>

							<?php if( $show_search_type == 'yes' ) : ?>
								<div class="ovacoll_type_search">
									<?php $dropdown_args = apply_filters( 'OVACOLL_type', $get_search_type ); ?>
								</div>
							<?php endif; ?>

							<input type="hidden" name="post_type" value="collection">
							<input type="hidden" name="search_collection" value="search-collection">
							<input class="ovacoll_submit" type="submit" value="<?php esc_html_e( 'Find Collection', 'ova-collection' ); ?>" />
						</form>
					</div>
				<?php endif; ?>
				
				<?php if($collections->have_posts() ) : ?>
					<div class="content_archive_coll <?php echo esc_attr( $collection_type );?>">
						<?php while ( $collections->have_posts() ) : $collections->the_post();
							ovacoll_get_template( 'parts/item-collection.php', $args_show );
						endwhile; ?>
					</div> 
				<?php else: ?>
					<div class="search_not_found">
						<?php esc_html_e( 'Not Found Collection', 'ova-collection' ); ?>
					</div>
				<?php endif; wp_reset_postdata(); ?>

				<?php 
					$args = array(
						'type'      => 'list',
						'next_text' => '<i class="ovaicon-next"></i><span class="visuallyhidden">Next</span>',
						'prev_text' => '<i class="ovaicon-back"></i><span class="visuallyhidden">Previous</span>',
					);

					the_posts_pagination($args);
				?>

			</div>

		</div>

	</div>
</div>


<?php get_footer( );