<?php if ( !defined( 'ABSPATH' ) ) exit();
	$id = get_the_id();

	$artist_skill 		= get_post_meta( $id, 'artist_skill', true );
	$artist_phone 		= get_post_meta( $id, 'artist_phone', true );
	$artist_email 		= get_post_meta( $id, 'artist_email', true );

	// show fields
	$show_image   = isset($args['show_image']) ? $args['show_image'] : 'yes';
	$show_title   = isset($args['show_title']) ? $args['show_title'] : 'yes';
	$show_skill   = isset($args['show_skill']) ? $args['show_skill'] : 'yes';
	$show_phone   = isset($args['show_phone']) ? $args['show_phone'] : 'yes';
	$show_email   = isset($args['show_email']) ? $args['show_email'] : 'yes';
?>	

<div class="item-artist">
	<div class="wrap_item">

		<?php if ($show_image == 'yes') { ?>
			<a class="img" href="<?php echo get_the_permalink(); ?>">
				<?php echo get_the_post_thumbnail(); ?>
			</a>
		<?php } ?>

		<?php if ($show_title == 'yes') { ?>
			<a class="name second_font" href="<?php echo get_the_permalink(); ?>">
				<?php echo get_the_title(); ?>
			</a>
		<?php } ?>

		<?php if ($artist_skill != '' && $show_skill == 'yes') { ?>
			<div class="skill"> 
				<?php echo esc_html($artist_skill);  ?>
			</div>
		<?php } ?>

		<div class="contact">
			<?php if ($artist_phone != '' && $show_phone == 'yes') { ?>
				<a class="phone" href="tel:<?php echo preg_replace('/\s+/', '', $artist_phone);  ?>">
					<?php echo esc_html($artist_phone);  ?>	
				</a>
			<?php } ?>

			<?php if ($artist_email != '' && $show_email == 'yes') { ?>
				<a href="mailto:<?php echo esc_html($artist_email); ?>" class="email"> 
					<?php echo esc_html( $artist_email );  ?>
				</a>
			<?php } ?>
		</div>
	</div>	

</div>