<?php
namespace ova_dep_elementor\Widgets;

use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class ova_dep_info extends Widget_Base {

	public function get_name() {
		return 'ova_dep_info';
	}

	public function get_title() {
		return esc_html__( 'Department Info', 'ova-dep' );
	}

	public function get_icon() {
		return 'eicon-info';
	}

	public function get_categories() {
		return [ 'ovatheme_dep' ];
	}

	public function get_script_depends() {
		return [ '' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'ovadep-info', OVADEP_PLUGIN_URI.'assets/css/elementor/ova-dep-info.css' );	
		return [];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Content', 'ova-dep' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

			$this->add_control(
				'wc_content_warning',
				[
					'type' 	=> \Elementor\Controls_Manager::RAW_HTML,
					'raw' 	=> esc_html__( "Don't enter Department ID if you use this element in Department Sidebar.In Elementor Preview ( When empty Department ID ) , this element display an example department info of the latest department", 'ova-dep' ),
					'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
				]
			);

			$this->add_control(
				'sid',
				[
					'label'  => esc_html__( 'Department ID', 'ova-dep' ),
					'type'   => \Elementor\Controls_Manager::NUMBER,
				]
			);	

			$this->add_control(
				'title',
				[
					'label'  => esc_html__( 'Title', 'ova-dep' ),
					'type'   => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__( 'Contact', 'ova-dep' ),
				]
			);	

			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name' => 'cate_border',
					'selector' => '{{WRAPPER}} .ova-dep-info .info',
				]
			);

		$this->end_controls_section();


		/* Title */
		$this->start_controls_section(
				'title_style_section',
				[
					'label' => esc_html__( 'Title', 'ova-dep' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'title_typography',
					'selector' => '{{WRAPPER}} .ova-dep-info .title',
				]
			);

			$this->add_control(
				'title_color',
				[
					'label' => esc_html__( 'Color', 'ova-dep' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-dep-info .title' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'title_background',
				[
					'label' => esc_html__( 'Background', 'ova-dep' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-dep-info .title' => 'background: {{VALUE}}',
						'{{WRAPPER}} .ova-dep-info .title:after' => 'border-top-color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$template = apply_filters( 'el_elementor_ova_dep_info', 'elementor/ova_dep_info.php' );

		ob_start();
		ovadep_get_template( $template, $settings );
		echo ob_get_clean();
	}
}
