<?php
namespace ova_dep_elementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class ova_dep_list_file extends Widget_Base {


	public function get_name() {
		return 'ova_dep_list_file';
	}

	public function get_title() {
		return esc_html__( 'File List In Department', 'ova-dep' );
	}

	public function get_icon() {
		return 'eicon-file-download';
	}

	public function get_categories() {
		return [ 'ovatheme_dep' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'ovadep-list-file', OVADEP_PLUGIN_URI.'assets/css/elementor/ova-dep-list-file.css' );	
		return [];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Content', 'ova-dep' ),
			]
		);

		
		$this->add_control(
			'id_dep',
			[
				'label'   => esc_html__( 'Department Id', 'ova-dep' ),
				'type'    => Controls_Manager::TEXT,
			]
		);

		$this->add_control( 
			'show_icon',
			[
				'label' => esc_html__( 'Show File Icon', 'ova-dep' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ova-dep' ),
				'label_off' => esc_html__( 'Hide', 'ova-dep' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_title',
			[
				'label' => esc_html__( 'Show Title', 'ova-dep' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ova-dep' ),
				'label_off' => esc_html__( 'Hide', 'ova-dep' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_file_size',
			[
				'label' => esc_html__( 'Show File Size', 'ova-dep' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ova-dep' ),
				'label_off' => esc_html__( 'Hide', 'ova-dep' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control( 
			'show_view_icon',
			[
				'label' => esc_html__( 'Show View Icon', 'ova-dep' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ova-dep' ),
				'label_off' => esc_html__( 'Hide', 'ova-dep' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control( 
			'show_download_icon',
			[
				'label' => esc_html__( 'Show Download Icon', 'ova-dep' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ova-dep' ),
				'label_off' => esc_html__( 'Hide', 'ova-dep' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
	}


	protected function render() {

		$settings = $this->get_settings();

		$template = apply_filters( 'el_elementor_ova_dep_list_file', 'elementor/ova_dep_list_file.php' );

		ob_start();
		ovadep_get_template( $template, $settings );
		echo ob_get_clean();
		
	}
}
