<?php if ( !defined( 'ABSPATH' ) ) exit();

	$all_ids = ova_dep_get_all_id();

	if( isset( $args['sid'] ) && $args['sid'] != '' ) {

	    $id  = ( in_array( $args['sid'], $all_ids ) == true ) ? $args['sid'] : get_the_id();

	} elseif( in_array( get_the_id(), $all_ids ) == false ) {

	    $id  = $all_ids[0];

	} else {
	    $id  = get_the_id();
	}

	// listing
	$group_listing  = get_post_meta( $id, 'ova_dep_met_listing', true ); 

?>

<?php if( $group_listing && is_array($group_listing) ) { ?>

	<div class="ova-dep-info">
	    <?php if($title) { ?>
			<h3 class="title"><?php echo esc_html( $title ); ?></h3>
		<?php } ?>

	    <div class="info">

			<?php foreach( $group_listing as $k => $listing ) {
				$listing_title  = isset( $listing['ova_dep_met_listing_title'] ) ? $listing['ova_dep_met_listing_title'] : ''; 
	            $listing_value  = isset( $listing['ova_dep_met_listing_value'] ) ? $listing['ova_dep_met_listing_value'] : ''; 
	            $listing_link   = isset( $listing['ova_dep_met_listing_link'] ) ? $listing['ova_dep_met_listing_link'] : ''; 
	            $target    		= apply_filters('ova_dep_ft_listing_target','_self');
			?>

				<div class="list-item">
					<?php if ( !empty($listing_title) ) : ?>	
						<span class="label">
							<?php echo esc_html( $listing_title ); ?>
						</span>
					<?php endif; ?>

					<?php if ( !empty($listing_link) && !empty($listing_value) ) : ?>	
					<a class="link-value" href="<?php echo esc_url( $listing_link ); ?>" target="<?php echo esc_attr( $target ); ?>">
				    <?php endif; ?>

					    <?php if ( !empty($listing_value) ) : ?>	
						<span class="value">
							<?php echo esc_html( $listing_value ); ?>
						</span>
						<?php endif; ?>

					<?php if ( !empty($listing_link)) : ?>	
					</a>
				    <?php endif; ?>
				</div>

			<?php } ?>       

	    </div>
	</div>

<?php } ?>