<?php
namespace ova_dir_elementor\Widgets;

use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class ova_dir_archive extends Widget_Base {

	public function get_name() {
		return 'ova_dir_archive';
	}

	public function get_title() {
		return esc_html__( 'Directory Archive', 'ova-dir' );
	}

	public function get_icon() {
		return 'eicon-posts-grid';
	}

	public function get_categories() {
		return [ 'ovatheme_directory' ];
	}

	public function get_script_depends() {
		$use_gg_map = get_theme_mod('ova_dir_use_google_map','yes');

		if ( $use_gg_map == 'yes' ) {
			if ( get_option( 'ova_dir_google_map_api', false ) ) {
				wp_enqueue_script('markerclusterer','https://unpkg.com/@googlemaps/markerclusterer/dist/index.min.js', array('jquery'),false, true);
				wp_enqueue_script( 'google','https://maps.googleapis.com/maps/api/js?key='.get_option( 'ova_dir_google_map_api', '' ).'&callback=Function.prototype&libraries=places', false, true );					
			} else {
				wp_enqueue_script( 'google_map','https://maps.googleapis.com/maps/api/js?sensor=false&callback=Function.prototype&libraries=places', array('jquery'), false, true );
			}
		}
	
		wp_enqueue_script('ova-dir-archive', OVADIR_PLUGIN_URI . 'assets/js/elementor/archive.js', array('jquery'),false, true);
		wp_localize_script( 'ova-dir-archive', 'ova_dir_ajax_object', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );

		return [ '' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'ovadir_frontend_styles', OVADIR_PLUGIN_URI.'assets/css/frontend/styles.css');
		return [];
	}

	protected function ova_dir_categories() {

		$cate_args = array(
			'taxonomy' => 'cat_dir',
			'orderby' => 'name',
			'order'   => 'ASC'
		);

		$categories = get_categories( $cate_args );
		$new_category = array( '0' => esc_html__('All', 'ova-dir') );
		if ( $categories ) {
			foreach ($categories as $key => $cate) {
				$new_category[$cate->term_id] = $cate->name;
			}
		}
		return $new_category;
	}

	protected function register_controls() {

		/* Directory */
		$this->start_controls_section(
			'dir_section',
			[
				'label' => esc_html__( 'Directory', 'ova-dir' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

			$categories = $this->ova_dir_categories();

			$this->add_control(
				'template',
				[
					'label' => esc_html__( 'Template', 'ova-dir' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'template_1',
					'options' => [
						'template_1' => esc_html__( 'Template 1', 'ova-dir' ),
						'template_2' => esc_html__( 'Template 2', 'ova-dir' ),
					],
				]
			);

			$this->add_control(
				'number_column',
				[
					'label' => esc_html__( 'Number Of Columns', 'ova-dir' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'three_column',
					'options' => [
						'one_column'   => esc_html__( '1 Columns', 'ova-dir' ),
						'two_column'   => esc_html__( '2 Columns', 'ova-dir' ),
						'three_column' => esc_html__( '3 Columns', 'ova-dir' ),
					],
				]
			);

			$this->add_control(
				'cate',
				[
					'label' => esc_html__( 'Active Category', 'ova-dir' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => '0',
					'options' => $categories,
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'posts_per_page',
				[
					'label' => esc_html__( 'Total', 'ova-dir' ),
					'type' => \Elementor\Controls_Manager::NUMBER,
					'min' => 1,
					'max' => 10,
					'step' => 1,
					'default' => 8,
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'order',
				[
					'label' => esc_html__( 'Order', 'ova-dir' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'ASC',
					'options' => [
						'ASC' => esc_html__( 'Ascending', 'ova-dir' ),
						'DESC' => esc_html__( 'Descending', 'ova-dir' ),
					],
				]
			);

			$this->add_control(
				'order_by',
				[
					'label' => esc_html__( 'Order By', 'ova-dir' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'title',
					'options' => [
						'ID'  	=> esc_html__( 'ID', 'ova-dir' ),
						'date'  => esc_html__( 'Date', 'ova-dir' ),
						'title' => esc_html__( 'Title', 'ova-dir' ),
						'rand'  => esc_html__( 'Random', 'ova-dir' ),
					],
				]
			);

			$this->add_control(
				'category_not_in',
				[
					'label'   		=> esc_html__( 'Category Not In', 'ova-dir' ),
					'type'    		=> \Elementor\Controls_Manager::TEXT,
					'description' 	=> esc_html__( 'Enter the directory category IDs. IDs are separated by "|". Ex: 1|2|3.', 'ova-dir' ),
				]
			);

			$this->add_control( 
				'show_filter',
				[
					'label' => esc_html__( 'Show Filter', 'ova-dir' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-dir' ),
					'label_off' => esc_html__( 'Hide', 'ova-dir' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control( 
				'show_map',
				[
					'label' => esc_html__( 'Show Map', 'ova-dir' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-dir' ),
					'label_off' => esc_html__( 'Hide', 'ova-dir' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control( 
				'show_image',
				[
					'label' => esc_html__( 'Show Image', 'ova-dir' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-dir' ),
					'label_off' => esc_html__( 'Hide', 'ova-dir' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control( 
				'show_title',
				[
					'label' => esc_html__( 'Show Title', 'ova-dir' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-dir' ),
					'label_off' => esc_html__( 'Hide', 'ova-dir' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control( 
				'show_location',
				[
					'label' => esc_html__( 'Show Location', 'ova-dir' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-dir' ),
					'label_off' => esc_html__( 'Hide', 'ova-dir' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control( 
				'show_category',
				[
					'label' => esc_html__( 'Show Category', 'ova-dir' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-dir' ),
					'label_off' => esc_html__( 'Hide', 'ova-dir' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control( 
				'show_short_desc',
				[
					'label' => esc_html__( 'Show Short Description', 'ova-dir' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-dir' ),
					'label_off' => esc_html__( 'Hide', 'ova-dir' ),
					'return_value' => 'yes',
					'default' => 'yes',
					'condition' => [
						'template' => 'template_2'
					]
				]
			);

			$this->add_control( 
				'show_link_to',
				[
					'label' => esc_html__( 'Show Link to Detail', 'ova-dir' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-dir' ),
					'label_off' => esc_html__( 'Hide', 'ova-dir' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

		$this->end_controls_section();

		/* General */
		$this->start_controls_section(
				'dir_style_section',
				[
					'label' => esc_html__( 'General', 'ova-dir' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'dir_margin',
				[
					'label' => esc_html__( 'Margin', 'ova-dir' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-dir-archive .ova-dir-items' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

		$this->end_controls_section();

		/* Items */
		$this->start_controls_section(
				'items_style_section',
				[
					'label' => esc_html__( 'Items', 'ova-dir' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'items_padding',
				[
					'label' => esc_html__( 'Padding', 'ova-dir' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-dir-archive .ova-dir-items .item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'items_box_shadow',
					'selector' => '{{WRAPPER}} .ova-dir-archive .ova-dir-items .item',
				]
			);

			$this->add_control(
				'items_bg',
				[
					'label' => esc_html__( 'Background', 'ova-dir' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-dir-archive .ova-dir-items .item' => 'background: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'title_style_section',
				[
					'label' => esc_html__( 'Title', 'ova-dir' ),
					'type' => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);

			$this->add_responsive_control(
				'title_margin',
				[
					'label' => esc_html__( 'Margin', 'ova-dir' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-dir-archive .ova-dir-items .item .content .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'title_typography',
					'selector' => '{{WRAPPER}} .ova-dir-archive .ova-dir-items .item .content .title a',
				]
			);

			$this->add_control(
				'title_color',
				[
					'label' => esc_html__( 'Color', 'ova-dir' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-dir-archive .ova-dir-items .item .content .title a' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'info_style_section',
				[
					'label' => esc_html__( 'Title', 'ova-dir' ),
					'type' => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);

			$this->add_responsive_control(
				'info_margin',
				[
					'label' => esc_html__( 'Margin', 'ova-dir' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-dir-archive .ova-dir-items .item .content .info' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'icon_style_section',
				[
					'label' => esc_html__( 'Icon', 'ova-dir' ),
					'type' => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);

			$this->add_control(
				'icon_size',
				[
					'label' => esc_html__( 'Size', 'ova-dir' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 40,
							'step' => 5,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .ova-dir-archive .ova-dir-items .item .content .info li i' => 'font-size: {{SIZE}}{{UNIT}};width: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'icon_color',
				[
					'label' => esc_html__( 'Color', 'ova-dir' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-dir-archive .ova-dir-items .item .content .info li i' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'info_text_style_section',
				[
					'label' => esc_html__( 'Text', 'ova-dir' ),
					'type' => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'info_text_typography',
					'selector' => '{{WRAPPER}} .ova-dir-archive .ova-dir-items .item .content .info li .text',
				]
			);

			$this->start_controls_tabs(
					'info_text_style_tabs'
				);

				$this->start_controls_tab(
						'info_text_style_normal_tab',
						[
							'label' => esc_html__( 'Normal', 'ova-dir' ),
						]
					);

				$this->add_control(
					'info_text_color',
					[
						'label' => esc_html__( 'Color', 'ova-dir' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-dir-archive .ova-dir-items .item .content .info li .text' => 'color: {{VALUE}}',
						],
					]
				);

				$this->end_controls_tab();

				$this->start_controls_tab(
						'info_text_style_hover_tab',
						[
							'label' => esc_html__( 'Link', 'ova-dir' ),
						]
					);

				$this->add_control(
					'info_text_color_link',
					[
						'label' => esc_html__( 'Color', 'ova-dir' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-dir-archive .ova-dir-items .item .content .info li a' => 'color: {{VALUE}}',
						],
					]
				);

				$this->end_controls_tab();

			$this->end_controls_tabs();

		$this->end_controls_section();

		/* Items Map */
		$this->start_controls_section(
				'items_map_style_section',
				[
					'label' => esc_html__( 'Items Map', 'ova-dir' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'items_map_padding',
				[
					'label' => esc_html__( 'Padding', 'ova-dir' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-dir-archive .property .card .content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'items_map_box_shadow',
					'selector' => '{{WRAPPER}} .ova-dir-archive .property .card',
				]
			);

			$this->add_control(
				'items_map_bg',
				[
					'label' => esc_html__( 'Background', 'ova-dir' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-dir-archive .property .card' => 'background: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'title_map_style_section',
				[
					'label' => esc_html__( 'Title', 'ova-dir' ),
					'type' => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);

			$this->add_responsive_control(
				'title_map_margin',
				[
					'label' => esc_html__( 'Margin', 'ova-dir' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-dir-archive .property .card .content .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'title_map_typography',
					'selector' => '{{WRAPPER}} .ova-dir-archive .property .card .content .title a',
				]
			);

			$this->add_control(
				'title_map_color',
				[
					'label' => esc_html__( 'Color', 'ova-dir' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-dir-archive .property .card .content .title a' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'info_map_style_section',
				[
					'label' => esc_html__( 'Info', 'ova-dir' ),
					'type' => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);

			$this->add_responsive_control(
				'info_map_margin',
				[
					'label' => esc_html__( 'Margin', 'ova-dir' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-dir-archive .property .card .content .info' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'icon_map_style_section',
				[
					'label' => esc_html__( 'Icon', 'ova-dir' ),
					'type' => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);

			$this->add_control(
				'icon_map_size',
				[
					'label' => esc_html__( 'Size', 'ova-dir' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 40,
							'step' => 5,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .ova-dir-archive .property .card .content .info li i' => 'font-size: {{SIZE}}{{UNIT}};width: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'icon_map_color',
				[
					'label' => esc_html__( 'Color', 'ova-dir' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-dir-archive .property .card .content .info li i' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'info_map_text_style_section',
				[
					'label' => esc_html__( 'Text', 'ova-dir' ),
					'type' => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'info_map_text_typography',
					'selector' => '{{WRAPPER}} .ova-dir-archive .property .card .content .info li .text',
				]
			);

			$this->start_controls_tabs(
					'info_map_text_style_tabs'
				);

				$this->start_controls_tab(
						'info_map_text_style_normal_tab',
						[
							'label' => esc_html__( 'Normal', 'ova-dir' ),
						]
					);

					$this->add_control(
						'info_map_text_color',
						[
							'label' => esc_html__( 'Color', 'ova-dir' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-dir-archive .property .card .content .info li .text' => 'color: {{VALUE}}',
							],
						]
					);

				$this->end_controls_tab();

				$this->start_controls_tab(
						'info_map_text_style_hover_tab',
						[
							'label' => esc_html__( 'Link', 'ova-dir' ),
						]
					);

					$this->add_control(
						'info_map_text_color_link',
						[
							'label' => esc_html__( 'Color', 'ova-dir' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-dir-archive .property .card .content .info li a' => 'color: {{VALUE}}',
							],
						]
					);

				$this->end_controls_tab();

			$this->end_controls_tabs();

		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();
		$template = apply_filters( 'el_elementor_ova_dir_archive', 'elementor/ova_dir_archive.php' );

		ob_start();
		ovadir_get_template( $template, $settings );
		echo ob_get_clean();
	}
}
