<?php if ( !defined( 'ABSPATH' ) ) exit();

	global $post;

	$sidebar = get_theme_mod( 'ova_dir_single_sidebar', 'right_sidebar' );

	$use_gg_map = get_theme_mod('ova_dir_use_google_map','yes');

	if($use_gg_map == 'yes'){
		$zoom 			= get_theme_mod( 'ova_dir_single_zoom', 14 );
		$latitude 		= get_post_meta( get_the_ID(), 'ova_dir_met_latitude', true );
		$longitude 		= get_post_meta( get_the_ID(), 'ova_dir_met_longitude', true );
		if ( ! $latitude ) {
			$latitude = get_theme_mod( 'ova_dir_latitude', 39.177972 );
		}
		if ( ! $longitude ) {
			$longitude = get_theme_mod( 'ova_dir_longitude', -100.36375 );
		}
		$data_map = array(
			'latitude' 	=> $latitude,
			'longitude' => $longitude,
			'zoom'		=> $zoom
		);
	}

	$contact 		= get_post_meta( get_the_ID(), 'ova_dir_contact_group', true );
	$opening_hours 	= get_post_meta( get_the_ID(), 'ova_dir_opening_group', true );
	$gallery 		= get_post_meta( get_the_ID(), 'ova_met_gallery_id', true );

	$category = get_the_terms( get_the_ID(), 'cat_dir' );  
	$tag 	  = get_the_terms( get_the_ID(), 'tag_dir' );

	// show fields
	$show_image   		= get_theme_mod( 'ova_dir_single_show_image', 'yes' );
	$show_content 		= get_theme_mod( 'ova_dir_single_show_content', 'yes' );
	$show_contact_title = get_theme_mod( 'ova_dir_single_show_contact_title', 'yes' );
	$show_contact	    = get_theme_mod( 'ova_dir_single_show_contact', 'yes' );
	$show_share 		= get_theme_mod( 'ova_dir_single_show_share', 'yes' );
	$show_map 			= get_theme_mod( 'ova_dir_single_show_map', 'yes' );
	$show_opening_hours	= get_theme_mod( 'ova_dir_single_show_opening_hours', 'yes' );
	$show_gallery		= get_theme_mod( 'ova_dir_single_show_gallery', 'yes' );
	$show_category		= get_theme_mod( 'ova_dir_single_show_category', 'yes' );
	$show_tags		    = get_theme_mod( 'ova_dir_single_show_tags', 'yes' );
	$show_comments 	    = get_theme_mod( 'ova_dir_comments', 'yes' );

get_header();

?>

<div class="ova-dir-single">
	<div class="container">
		<div class="row_site">
			<div class="container_site">

				<div class="ova-dir-wrapper <?php printf( '%1$s', $sidebar ); ?>">
					<?php if ( $sidebar == 'left_sidebar' && is_active_sidebar( 'ova-dir-sidebar' ) ) { ?>
						<div class="ova-dir-sidebar-wrapper">
							<div class="ova-dir-sidebar">
								<?php dynamic_sidebar('ova-dir-sidebar'); ?>
							</div>
						</div>
					<?php } ?>

					<div class="ova_dir_content">
						<?php if( have_posts() ) : while( have_posts() ) : the_post(); ?>

							<?php if ( has_post_thumbnail() && $show_image == 'yes' ): ?>
								<div class="thumbnail">
									<?php the_post_thumbnail('large'); ?>
								</div>
							<?php endif; ?>

							<?php if ( $show_content == 'yes' ): ?>
								<div class="content">
									<?php the_content(); ?>
								</div>
							<?php endif; ?>

							<?php if ( $contact && $show_contact == 'yes' ) { ?>
								<div class="contact-box">
									<?php if ( $show_contact_title == 'yes' ): ?>
										<h2 class="title">
											<?php esc_html_e( 'Contact', 'ova-dir' ); ?>
										</h2>
									<?php endif; ?>
									<ul class="contact-list">
										<?php foreach ($contact as $key => $item) { ?>
											<li class="item">
												<?php if ( isset($item['ova_dir_met_contact_icon']) && !empty($item['ova_dir_met_contact_icon']) ): ?>
													<i class="<?php echo esc_attr( $item['ova_dir_met_contact_icon'] ); ?>" aria-hidden="true"></i>
												<?php endif; ?>
												<?php if ( isset($item['ova_dir_met_contact_link']) && !empty($item['ova_dir_met_contact_link']) ): ?>
													<a href="<?php echo esc_url( $item['ova_dir_met_contact_link'] ); ?>" 
														title="<?php echo esc_attr( $item['ova_dir_met_contact_label'] ); ?>"
													>
														<?php echo esc_html( $item['ova_dir_met_contact_label'] ); ?>
													</a>
												<?php else: ?>
													<span><?php echo esc_html( $item['ova_dir_met_contact_label'] ); ?></span>
												<?php endif; ?>
											</li>
										<?php } ?>
									</ul>
								</div>
							<?php } ?>

				 		<?php endwhile; endif; wp_reset_postdata(); ?>

				 		<?php if( has_filter( 'ova_share_social' ) && $show_share == 'yes' ){ ?>
					        <?php apply_filters( 'ova_share_social', get_the_permalink(), get_the_title()  ); ?>
				        <?php } ?>

				        <?php if( $show_map == 'yes' && $use_gg_map == 'yes' ){ ?>
				        <div id="ova_dir_single_google_map" data-map="<?php echo esc_attr( json_encode( $data_map ) ); ?>"></div>
				         <?php } ?>

				        <?php if ( $opening_hours && $show_opening_hours == 'yes' ): ?>
					        <div class="opening_hours">
					        	<h2 class="title">
					        		<?php esc_html_e( 'Opening hours', 'ova-dir' ) ?>
					        	</h2>
					        	<table class="table">
					        		<?php foreach ($opening_hours as $key => $item): ?>
						        		<tr>
						        			<?php if(isset($item['ova_dir_met_opening_day'])) : ?>
							        			<td class="day">
							        				<?php echo esc_html( $item['ova_dir_met_opening_day'] ); ?>
							        			</td>
							        		<?php endif ?>
							        		<?php if(isset($item['ova_dir_met_opening_hours']) && isset($item['ova_dir_met_closing_hours'])) : ?>
							        			<td class="time">
							        				<?php echo esc_html( $item['ova_dir_met_opening_hours'] .' - '. $item['ova_dir_met_closing_hours'] ); ?>
							        			</td>
							        		<?php endif ?>
						        		</tr>
					        		<?php endforeach; ?>
					        	</table>
					        </div>
				        <?php endif; ?>

				        <?php if ( $gallery && $show_gallery == 'yes' ): ?>
					        <div class="gallery">
					        	<h2 class="title">
					        		<?php esc_html_e( 'Gallery', 'ova-dir' ) ?>
					        	</h2>
					        	<div class="gallery-inner">
					        		<?php foreach ( $gallery as $key => $image_id ):
					        			$image_url 		= wp_get_attachment_url( $image_id );
					        			$image_size_url = wp_get_attachment_image_url( $image_id, 'thumbnail' );
					        			$image_alt 		= get_post_meta($image_id, '_wp_attachment_image_alt', true);
										$image_title 	= get_the_title($image_id);
										if ( ! $image_alt ) {
											$image_alt = $image_title;
										}
					        		?>
					        			<a href="#" class="gallery-item" data-src="<?php echo esc_url( $image_url ); ?>" 
					        				data-fancybox="gallery" 
					        				data-thumb="<?php echo esc_url( $image_size_url ); ?>" 
					        				data-caption="<?php echo esc_attr( $image_alt ); ?>"
					        			>
										  <img src="<?php echo esc_url( $image_size_url ); ?>" alt="<?php echo esc_attr( $image_alt ); ?>" />
										</a>
					        		<?php endforeach; ?>
					        	</div>
					        </div>
				        <?php endif; ?>

				        <?php if( !empty($category[0]->name) || !empty($tag[0]->name) ) { ?>
					        <ul class="metabox">
					        	<?php if( !empty($category[0]->name) && $show_category == 'yes' ) { ?>
						        	<li class="item">
						        		<i class="far fa-folder"></i>
						        		<div class="text">
						        			<?php the_terms( get_the_ID(), 'cat_dir' ); ?>	
						        		</div>
						        	</li>
					        	<?php } ?>
					        	<?php if( !empty($tag[0]->name) && $show_tags == 'yes' ) { ?>
						        	<li class="item">
						        		<i class="fas fa-tags"></i></i>
						        		<div class="text">
						        			<?php the_terms( get_the_ID(), 'tag_dir' );?>
						        		</div>
						        	</li>
						        <?php } ?>
					        </ul>
					    <?php } ?>

				        <?php if($show_comments == 'yes') {
					        if( comments_open( get_the_ID() ) ) {
					        	comments_template(); 
					        }
				        } ?>
					</div>

					<?php if ( $sidebar == 'right_sidebar' && is_active_sidebar( 'ova-dir-sidebar' ) ) { ?>
						<div class="ova-dir-sidebar-wrapper">
							<div class="ova-dir-sidebar">
								<?php dynamic_sidebar('ova-dir-sidebar'); ?>
							</div>
						</div>
					<?php } ?>
				</div>

			</div>
		</div>
	</div>
</div>

<?php get_footer();