<?php
namespace ova_ovaev_elementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class ova_events_ajax extends Widget_Base {

	public function get_name() {
		return 'ova_events_ajax';
	}

	public function get_title() {
		return esc_html__( 'Event Filter Ajax', 'ovaev' );
	}

	public function get_icon() {
		return 'eicon-gallery-grid';
	}

	public function get_categories() {
		return [ 'ovatheme_event' ];
	}

	public function get_script_depends() {
		wp_enqueue_script( 'ovaev-filter-ajax', OVAEV_PLUGIN_URI.'assets/js/elementor/events-filter-ajax.js',  [ 'jquery' ], false, true );
		return [ '' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_setting',
			[
				'label' => esc_html__( 'Settings', 'ovaev' ),
			]
		);

			$this->add_control(
				'layout',
				[
					'label'   => esc_html__('Layout', 'ovaev'),
					'type'    => Controls_Manager::SELECT,
					'options' => [
						'1' => esc_html__('Layout 1','ovaev'),
						'2' => esc_html__('Layout 2','ovaev'),
						'3' => esc_html__('Layout 3','ovaev'),
						'4' => esc_html__('Layout 4','ovaev'),
						'5' => esc_html__('Layout 5','ovaev'),
						'6' => esc_html__('Layout 6','ovaev'),
						'7' => esc_html__('Layout 7','ovaev'),
					],
					'default' => '2',
				]
			);

			$this->add_control(
				'show_filter',
				[
					'label' => esc_html__( 'Show Filter', 'ovaev' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ovaev' ),
					'label_off' => esc_html__( 'Hide', 'ovaev' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_all',
				[
					'label' => esc_html__( 'Show All', 'ovaev' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ovaev' ),
					'label_off' => esc_html__( 'Hide', 'ovaev' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_featured',
				[
					'label' => esc_html__( 'Show Only Featured', 'ovaev' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ovaev' ),
					'label_off' => esc_html__( 'Hide', 'ovaev' ),
					'return_value' => 'yes',
					'default' => 'no',
				]
			);

			$this->add_control(
				'show_read_more',
				[
					'label'        => esc_html__( 'Show All Events Button', 'ovaev' ),
					'type'         => Controls_Manager::SWITCHER,
					'return_value' => 'yes',
					'default'      => 'yes',
				]
			);

			$this->add_control(
				'text_read_more',
				[
					'label'       => esc_html__( 'Text Button', 'ovaev' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => esc_html__( 'See All Events', 'ovaev' ),
					'condition' => [
						'show_read_more' => 'yes'
					]
				]
			);


			$this->add_control(
				'number_post',
				[
					'label' => esc_html__( 'Total', 'ovaev' ),
					'type' => \Elementor\Controls_Manager::NUMBER,
					'default' => 6,
				]
			);

			$this->add_control(
				'orderby_post',
				[
					'label' => esc_html__( 'OrderBy', 'ovaev' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'date',
					'options' => [
						'date' => esc_html__( 'Date', 'ovaev' ),
						'id'  => esc_html__( 'ID', 'ovaev' ),
						'title' => esc_html__( 'Title', 'ovaev' ),
						'rand' => esc_html__( 'Random', 'ovaev' ),
					],
				]
			);

			$this->add_control(
				'order_post',
				[
					'label' => esc_html__( 'Order', 'ovaev' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'DESC',
					'options' => [
						'ASC' => esc_html__( 'Ascending', 'ovaev' ),
						'DESC'  => esc_html__( 'Descending', 'ovaev' ),
					],
				]
			);

			$this->add_control(
				'exclude_cat',
				[
					'label' => esc_html__( 'Excluded Categories', 'ovaev' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'description' => 'ID category, example: 5, 7',
				]
			);

			$this->add_control(
				'show_thumbnail',
				[
					'label'        => esc_html__( 'Show Thumbnail', 'ovaev' ),
					'type'         => Controls_Manager::SWITCHER,
					'return_value' => 'yes',
					'default'      => 'yes',
					'separator' => 'before'
				]
			);

			$this->add_control(
				'show_date',
				[
					'label'        => esc_html__( 'Show Date', 'ovaev' ),
					'type'         => Controls_Manager::SWITCHER,
					'return_value' => 'yes',
					'default'      => 'yes',
					'condition'    => [
						'layout!' => '7'
					]
				]
			);

			$this->add_control(
				'show_hour',
				[
					'label'        => esc_html__( 'Show Hour', 'ovaev' ),
					'type'         => Controls_Manager::SWITCHER,
					'return_value' => 'yes',
					'default'      => 'yes',
					'condition'    => [
						'layout!' => '6'
					]
				]
			);

			$this->add_control(
				'show_location',
				[
					'label'        => esc_html__( 'Show Location', 'ovaev' ),
					'type'         => Controls_Manager::SWITCHER,
					'return_value' => 'yes',
					'default'      => 'yes',
				]
			);

			$this->add_control(
				'show_event_title',
				[
					'label'        => esc_html__( 'Show Title', 'ovaev' ),
					'type'         => Controls_Manager::SWITCHER,
					'return_value' => 'yes',
					'default'      => 'yes',
				]
			);

			$this->add_control(
				'show_short_desc',
				[
					'label'        => esc_html__( 'Show Excerpt', 'ovaev' ),
					'type'         => Controls_Manager::SWITCHER,
					'return_value' => 'yes',
					'default'      => 'yes',
					'condition'    => [
						'layout' => '5',
					]
				]
			);

			$this->add_control(
				'show_link_to',
				[
					'label'        => esc_html__( 'Show Link to Detail', 'ovaev' ),
					'type'         => Controls_Manager::SWITCHER,
					'return_value' => 'yes',
					'default'      => 'yes',
				]
			);
			

		$this->end_controls_section();

		$this->start_controls_section(
			'section_addtional_options_setting',
			[
				'label' => esc_html__( 'Additional Options', 'ovaev' ),
			]
		);	

			$this->add_control(
				'owl_items',
				[
					'label' => esc_html__( 'Items', 'evaev' ),
					'type' => \Elementor\Controls_Manager::NUMBER,
					'default' => 3,
				]
			);

			$this->add_control(
				'owl_margin',
				[
					'label' => esc_html__( 'Margin', 'evaev' ),
					'type' => \Elementor\Controls_Manager::NUMBER,
					'default' => 30,
				]
			);

			$this->add_control(
				'owl_show_nav',
				[
					'label' => esc_html__( 'Show Nav', 'evaev' ),
					'type' => Controls_Manager::SWITCHER,
					'default' => 'yes',
				]
			);

			$this->add_control(
				'owl_autoplay',
				[
					'label' => esc_html__( 'Autoplay', 'evaev' ),
					'type' => Controls_Manager::SWITCHER,
					'default' => 'no',
				]

			);

			$this->add_control(
				'owl_autoplay_speed',
				[
					'label' => esc_html__( 'Autoplay Speed (ms)', 'evaev' ),
					'type' => Controls_Manager::NUMBER,
					'default' => 5000,
					'condition' => [
						'owl_autoplay' => 'yes',
					],
					
				]
			);

			$this->add_control(
				'owl_loop',
				[
					'label' => esc_html__( 'Infinite Loop', 'evaev' ),
					'type' => Controls_Manager::SWITCHER,
					'default' => 'no',
				]
			);

			$this->add_control(
				'owl_lazyload',
				[
					'label' => esc_html__( 'Lazy Load', 'evaev' ),
					'type' => Controls_Manager::SWITCHER,
					'default' => 'yes',
				]
			);

			$this->add_control(
				'owl_nav_prev',
				[
					'label' => esc_html__( 'Class Nav Prev', 'evaev' ),
					'type' => Controls_Manager::TEXT,
					'default' => 'arrow_carrot-left',
					'placeholder' => 'arrow_carrot-left'
				]
			);

			$this->add_control(
				'owl_nav_next',
				[
					'label' => esc_html__( 'Class Nav Next', 'evaev' ),
					'type' => Controls_Manager::TEXT,
					'default' => 'arrow_carrot-right',
					'placeholder' => 'arrow_carrot-right'
				]
			);

		$this->end_controls_section();




		$this->start_controls_section(
			'section_style_fillter',
			[
				'label' => esc_html__( 'Button Fillter', 'ovaev' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'button_filter_typo',
				'label' => esc_html__( 'Typography', 'ovaev' ),
				'selector' => '{{WRAPPER}} .ovapo_project_grid .button-filter button',
			]
		);

		$this->add_control(
			'button_filter_color',
			[
				'label' => esc_html__( 'Color', 'ovaev' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ovapo_project_grid .button-filter button' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'button_filter_color_hover',
			[
				'label' => esc_html__( 'Color Hover', 'ovaev' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ovapo_project_grid .button-filter button:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'button_filter_color_active',
			[
				'label' => esc_html__( 'Color Active', 'ovaev' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ovapo_project_grid .button-filter button.active' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'button_filter_padding',
			[
				'label' => esc_html__( 'Padding', 'ovaev' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .ovapo_project_grid .button-filter' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

	}

	public function get_data_ajax() {
		$settings = $this->get_settings();
		
		//data post
		$number_post 	= $settings['number_post'];
		$order_post 	= $settings['order_post'];
		$orderby_post 	= $settings['orderby_post'];
		$show_all 		= $settings['show_all'];
		$show_featured 	= $settings['show_featured'];
		$show_filter 	= $settings['show_filter'];
		$exclude_cat 	= $settings['exclude_cat'];
		$text_read_more = $settings['text_read_more'];
        $show_read_more = $settings['show_read_more'];

        $cat_exclude = array(
			'exclude' => explode(", ",$exclude_cat), 
		);

		$terms 				= get_terms('event_category', $cat_exclude);
		$settings['terms'] 	= $terms;
		$count 				= count($terms);

		$term_id_filter 	= array();
		foreach ( $terms as $term ) {
			$term_id_filter[] = $term->term_id;
		}

		$term_id_filter_string = implode(", ", $term_id_filter);
		$first_term = '';
		if( $terms ){
			$first_term = $terms[0]->term_id;	
		}
		$settings['first_term'] 			= $first_term;
		$settings['term_id_filter_string'] 	= $term_id_filter_string;
		$settings['column'] 				= 1;

		$args_featured = $args_cat = array();
		
		$args_base = array(
			'post_type' 		=> 'event',
			'post_status' 		=> 'publish',
			'posts_per_page' 	=> $number_post,
			'order' 			=> $order_post,
			'orderby' 			=> $orderby_post,
		);


		/* Show Featured */
		if ($show_featured == 'yes') {
			$args_featured = array(
				'meta_key' => 'ovaev_special',
				'meta_query'=> array(
					array(
						'key' 		=> 'ovaev_special',
						'compare' 	=> '=',
						'value' 	=> 'checked',
					)
				)
			);
		}

		if ($show_all !== 'yes' && $first_term != '' ) {
			$args_cat = array(
				'tax_query' => array(
					array(
						'taxonomy' => 'event_category',
						'field'    => 'id',
						'terms'    => $first_term,
					)
				)
			);
		}

		$args = array_merge_recursive($args_cat, $args_base, $args_featured);
		$event_posts = new \WP_Query( $args );

		// data carousel
		$data_carousel = [
			'items'           => $settings['owl_items'],
			'slideBy'		  => 1,
			'margin'          => $settings['owl_margin'],
			'dots'            => false,
			'nav'             => $settings['owl_show_nav'] === 'yes' ? true : false,
			'autoplay'        => $settings['owl_autoplay'] === 'yes' ? true : false,
			'autoplayTimeout' => $settings['owl_autoplay_speed'],
			'loop'            => $settings['owl_loop'] 	   === 'yes' ? true : false,
			'lazyLoad'        => $settings['owl_lazyload'] === 'yes' ? true : false,
			'rtl'             => is_rtl() ? true : false,
			'mouseDrag'       => $event_posts->found_posts == 1 ? false : true,
			'navText' => [
				'<i class="'.$settings['owl_nav_prev'].'"></i>',
				'<i class="'.$settings['owl_nav_next'].'"></i>'
			],
			'responsive' => [
				'0'  	=> [
					'items'  => 1,
				],
				'768'  	=> [
					'items'  => 2,
				],
				'1024'  => [
					'items'  => $settings['owl_items'],
				]
			]
		];

		// show fileds
		$args_show = array(
			'show_thumbnail'  => $settings['show_thumbnail'],
			'show_date' 	  => $settings['show_date'],
			'show_hour' 	  => $settings['show_hour'],
			'show_location'   => $settings['show_location'],
			'show_title' 	  => $settings['show_event_title'],
			'show_short_desc' => $settings['show_short_desc'],
			'show_link_to' 	  => $settings['show_link_to'],
		);

		$data = [
			'data_posts' 	=> $event_posts,
			'data_carousel' => $data_carousel,
			'settings' 		=> $settings,
			'args_show'     => $args_show
		];

		return $data;
	}

	protected function render() {

		$settings = $this->get_data_ajax();

		$template = apply_filters( 'elementor_ovaev_ajax', 'elements/ovaev_events_ajax_content.php' );
		ob_start();
		ovaev_get_template( $template, $settings );
		echo ob_get_clean();
	}
}