<?php if( !defined( 'ABSPATH' ) ) exit();

global $post;

$date = 'Y/m/d';
$time = 'H:i';
$lang = OVAEX_Settings::ovaex_format_date_lang();

$exhibition_artist = get_post_meta( $post->ID,'exhibition_artist', true ) ? get_post_meta( $post->ID,'exhibition_artist', true ) : array();

if(class_exists('ovacollection')) {
	$exhibition_artists = OVACOLL_get_data::OVACOLL_get_all_artist();
} else {
	$exhibition_artists = [];
}

$ex_start_date            = get_post_meta( $post->ID, 'ex_start_date', true ) ? get_post_meta( $post->ID, 'ex_start_date', true ) : '';
$ex_end_date              = get_post_meta( $post->ID, 'ex_end_date', true ) ? get_post_meta( $post->ID, 'ex_end_date', true ) : '';
$ex_morning_time          = get_post_meta( $post->ID, 'ex_morning_time', true ) ? get_post_meta( $post->ID, 'ex_morning_time', true ) : '';
$ex_afternoon_time        = get_post_meta( $post->ID, 'ex_afternoon_time', true ) ? get_post_meta( $post->ID, 'ex_afternoon_time', true ) : '';
$ex_evening_time          = get_post_meta( $post->ID, 'ex_evening_time', true ) ? get_post_meta( $post->ID, 'ex_evening_time', true ) : '';
$ex_closed                = get_post_meta( $post->ID, 'ex_closed', true ) ? get_post_meta( $post->ID, 'ex_closed', true ) : '';
$ex_curator               = get_post_meta( $post->ID, 'ex_curator', true ) ? get_post_meta( $post->ID, 'ex_curator', true ) : '';
$ex_location              = get_post_meta( $post->ID, 'ex_location', true ) ? get_post_meta( $post->ID, 'ex_location', true ) : '';
$ex_duaration             = get_post_meta( $post->ID, 'ex_duaration', true ) ? get_post_meta( $post->ID, 'ex_duaration', true ) : '';
$ovaex_embed_video_link   = get_post_meta( $post->ID, 'ovaex_embed_video_link', true ) ? get_post_meta( $post->ID, 'ovaex_embed_video_link', true ) : '';
$ovaex_member_book_link   = get_post_meta( $post->ID, 'ovaex_member_book_link', true ) ? get_post_meta( $post->ID, 'ovaex_member_book_link', true ) : '#';
$ovaex_target_member_book = get_post_meta( $post->ID, 'ovaex_target_member_book', true ) ? get_post_meta( $post->ID, 'ovaex_target_member_book', true ) : '';
$ovaex_order_book_link    = get_post_meta( $post->ID, 'ovaex_order_book_link', true ) ? get_post_meta( $post->ID, 'ovaex_order_book_link', true ) : '#';
$ovaex_target_order_book  = get_post_meta( $post->ID, 'ovaex_target_order_book', true ) ? get_post_meta( $post->ID, 'ovaex_target_order_book', true ) : '';
$checked                  = get_post_meta( $post->ID, 'ovaex_special', true ) ? get_post_meta( $post->ID, 'ovaex_special', true ) : '' ;
$exhibition_custom_sort   = get_post_meta( $post->ID, 'exhibition_custom_sort', true ) ? get_post_meta( $post->ID, 'exhibition_custom_sort', true ) : '1' ;

if ( $ex_start_date && $ex_end_date ) {
	$ex_start_date_time = date_i18n( $date .' '. $time, $ex_start_date );
	$ex_end_date_time   =  date_i18n( $date .' '. $time, $ex_end_date );	
} else {
	$ex_start_date_time = $ex_end_date_time = '';
}

?>

<div class="ovaex_metabox">
	<br>
	<div class="ovaex_row">
		<label class="label"><strong><?php esc_html_e( 'Time:', 'ovaex' ); ?></strong></label>
		<input 
			type="text" 
			class="ex_start_date" 
			data-date="<?php echo esc_attr( $date .' '. $time ); ?>" 
			data-lang="<?php echo esc_attr( $lang ) ;?>" 
			autocomplete="off" 
			value="<?php echo esc_attr( $ex_start_date_time ); ?>" 
			placeholder="<?php esc_attr_e( 'Insert Time Start', 'ovaex' ); ?>"  
			name="ex_start_date" />
		<input 
			type="text" 
			class="ex_end_date" 
			data-date="<?php echo esc_attr( $date .' '. $time ); ?>" 
			data-lang="<?php echo esc_attr( $lang ); ?>" 
			autocomplete="off" 
			value="<?php echo esc_attr( $ex_end_date_time ); ?>" 
			placeholder="<?php esc_attr_e( 'Insert Time End', 'ovaex' ); ?>" 
			name="ex_end_date" />
	</div>
	<br>
	<div class="ovaex_row">
		<label class="label"><strong><?php esc_html_e( 'Morning:', 'ovaex' ); ?></strong></label>
		<input 
			type="text" 
			id="ex_morning_time" 
			value="<?php echo esc_attr( $ex_morning_time ); ?>" 
			placeholder="<?php esc_attr_e( '7:00 - 11:00', 'ovaex' ); ?>" 
			name="ex_morning_time" />
	</div>
	<br>
	<div class="ovaex_row">
		<label class="label"><strong><?php esc_html_e( 'Afternoon:', 'ovaex' ); ?></strong></label>
		<input 
			type="text" 
			id="ex_afternoon_time" 
			value="<?php echo esc_attr( $ex_afternoon_time ); ?>" 
			placeholder="<?php esc_attr_e( '13:00 - 17:00', 'ovaex' ); ?>" 
			name="ex_afternoon_time" />
	</div>
	<br>
	<div class="ovaex_row">
		<label class="label"><strong><?php esc_html_e( 'Evening:', 'ovaex' ); ?></strong></label>
		<input 
			type="text" 
			id="ex_evening_time" 
			value="<?php echo esc_attr( $ex_evening_time ); ?>" 
			placeholder="<?php esc_attr_e( '18:00 - 21:00', 'ovaex' ); ?>" 
			name="ex_evening_time" />
	</div>
	<br>
	<div class="ovaex_row">
		<label class="label"><strong><?php esc_html_e( 'Closed:', 'ovaex' ); ?></strong></label>
		<input 
			type="text" 
			id="ex_closed" 
			value="<?php echo esc_attr( $ex_closed ); ?>" 
			placeholder="<?php esc_attr_e( 'Sunday', 'ovaex' ); ?>" 
			name="ex_closed" />
	</div>
	<br>
	<div class="ovaex_row">
		<label class="label"><strong><?php esc_html_e( 'Curators:', 'ovaex' ); ?></strong></label>
		<input 
			type="text" 
			id="ex_curator" 
			value="<?php echo esc_attr( $ex_curator ); ?>" 
			placeholder="<?php esc_attr_e( 'Insert Curators', 'ovaex' ); ?>" 
			name="ex_curator" />
	</div>
	<br>
	<div class="ovaex_row">
		<label class="label"><strong><?php esc_html_e( 'Location:', 'ovaex' ); ?></strong></label>
		<input 
			type="text" 
			id="ex_location" 
			value="<?php echo esc_attr( $ex_location ); ?>" 
			placeholder="<?php esc_attr_e( 'New York', 'ovaex' ); ?>" 
			name="ex_location" />
	</div>
	<br>
	<div class="ovaex_row">
		<label class="label"><strong><?php esc_html_e( 'Duration:', 'ovaex' ); ?></strong></label>
		<input 
			type="text" 
			id="ex_duaration" 
			value="<?php echo esc_attr( $ex_duaration ); ?>" 
			placeholder="<?php esc_attr_e( '60 Minutes', 'ovaex' ); ?>" 
			name="ex_duaration" />
	</div>
	<br>
	<div class="ovaex_row">
		<label class="label"><strong><?php esc_html_e( 'Embed Video Link:', 'ovaex' ); ?></strong></label>
		<input 
			type="text" 
			id="ovaex_embed_video_link" 
			value="<?php echo esc_attr( $ovaex_embed_video_link ); ?>" 
			placeholder="<?php esc_attr_e( 'https://www.youtube.com/watch?v=XHOmBV4js_E', 'ovaex' ); ?>"  
			name="ovaex_embed_video_link" 
			autocomplete="off" />
	</div>
	<br>
	<div class="ovaex_row">
		<label class="label"><strong><?php esc_html_e( 'Member:', 'ovaex' ); ?></strong></label>
		<?php
			$member_target_self 	= '_self' == $ovaex_target_member_book ? 'selected' : '';
			$member_target_blank 	= '_blank' == $ovaex_target_member_book ? 'selected' : '';
		?>
		<input 
			type="text" 
			id="ovaex_member_book_link" 
			value="<?php echo esc_attr( $ovaex_member_book_link ); ?>" 
			placeholder="<?php esc_attr_e( 'Insert link', 'ovaex' ); ?>" 
			name="ovaex_member_book_link" 
			autocomplete="off" />
		<select id="ovaex_target_member_book" name="ovaex_target_member_book">
			<option <?php echo $member_target_self ?> value="_self">
				<?php esc_html_e( 'Self', 'ovaex' ); ?>
			</option>
			<option <?php echo $member_target_blank ?> value="_blank">
				<?php esc_html_e( 'Blank', 'ovaex' ); ?>
			</option>
		</select>
	</div>
	<br>
	<div class="ovaex_row">
		<label class="label"><strong><?php esc_html_e( 'Order Ticket:', 'ovaex' ); ?></strong></label>
		<?php
			$order_target_self 	= '_self' == $ovaex_target_order_book ? 'selected' : '';
			$order_target_blank = '_blank' == $ovaex_target_order_book ? 'selected' : '';
		?>
		<input 
			type="text" 
			id="ovaex_order_book_link" 
			value="<?php echo esc_attr( $ovaex_order_book_link ); ?>" 
			placeholder="<?php esc_attr_e( 'Insert link', 'ovaex' ); ?>" 
			name="ovaex_order_book_link" 
			autocomplete="off" />
		<select id="ovaex_target_order_book" name="ovaex_target_order_book">
			<option <?php echo $order_target_self ?> value="_self">
				<?php esc_html_e( 'Self', 'ovaex' ); ?>
			</option>
			<option <?php echo $order_target_blank ?> value="_blank">
				<?php esc_html_e( 'Blank', 'ovaex' ); ?>
			</option>
		</select>
	</div>
	<br>
	<div class="ovaex_row">
		<label class="label"><strong><?php esc_html_e( 'Special Exhibition:', 'ovaex' ); ?></strong></label>
		<input type="checkbox" value="<?php echo esc_attr($checked); ?>" name="ovaex_special" <?php echo esc_attr($checked); ?> />
	</div>
	<br>
	<?php if(!empty($exhibition_artists)) : ?>
		<div class="ovaex_row">
			<label class="label"><strong><?php esc_html_e( 'Artists:', 'ovaex' ); ?></strong></label>
			<select name="exhibition_artist[]" multiple>
				<?php foreach( $exhibition_artists as $id ) {
					$selected = in_array( $id, $exhibition_artist ) == true ? 'selected' : '';
				?>
					<option value="<?php echo esc_attr( $id ); ?>" <?php echo esc_attr( $selected ); ?> > 
						<?php echo get_the_title( $id ); ?>
					</option>
				<?php } ?>
			</select>
		</div>
		<br>
	<?php endif; ?>
	<div class="ovaex_row">
		<label class="label"><strong><?php esc_html_e( 'Custom Sort:', 'ovaex' ); ?></strong></label>
		<input type="text" value="<?php echo esc_attr( $exhibition_custom_sort ); ?>" name="exhibition_custom_sort" />
	</div>
	<br>
</div>
<?php wp_nonce_field( 'ovaex_nonce', 'ovaex_nonce' ); ?>