<?php defined( 'ABSPATH' ) || exit();

if( !class_exists( 'OVAEX_Assets' ) ){
	class OVAEX_Assets{

		public function __construct(){

			add_action( 'wp_enqueue_scripts', array( $this, 'ovaex_enqueue_style' ) );

			/* Add JS for Elementor */
			add_action( 'elementor/frontend/after_register_scripts', array( $this, 'ova_enqueue_scripts_elementor_ovaex' ) );
		}

		public function ovaex_enqueue_style(){

			if ( is_post_type_archive( 'exhibition' ) || is_tax( 'cat_exhibition' ) ){
				wp_enqueue_style( 'ovaex-style', OVAEX_PLUGIN_URI.'assets/css/frontend/ovaex-style.css', array(), null );
			}
			
			if ( is_singular( 'exhibition' ) ){
				// Map
				wp_enqueue_script( 'google','https://maps.googleapis.com/maps/api/js?key='.OVAEX_Settings::google_key_map().'&libraries=places', false, true );

				// Owl carousel
				wp_enqueue_style( 'owl-carousel', OVAEX_PLUGIN_URI.'assets/libs/owl-carousel/assets/owl.carousel.min.css' );
				wp_enqueue_script( 'owl-carousel', OVAEX_PLUGIN_URI.'assets/libs/owl-carousel/owl.carousel.min.js', array('jquery'), false, true );

				wp_enqueue_style( 'ovaex-style', OVAEX_PLUGIN_URI.'assets/css/frontend/ovaex-style.css', array(), null );
				wp_enqueue_script( 'ovaex-script', OVAEX_PLUGIN_URI.'assets/js/frontend/ovaex-script.js', array('jquery'), false, true );
			}

		}

		// Add JS for elementor
		public function ova_enqueue_scripts_elementor_ovaex(){
			wp_register_script( 'script-elementor-ovaex', OVAEX_PLUGIN_URI. 'assets/js/script-elementor.js', [ 'jquery' ], false, true );
			wp_localize_script('script-elementor-ovaex', 'load_more', array( 'url' => admin_url('admin-ajax.php') ));
		}
	}

	new OVAEX_Assets();
}