<?php
namespace ova_por_elementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class ova_por_gallery extends Widget_Base {

	public function get_name() {
		return 'ova_por_gallery';
	}

	public function get_title() {
		return esc_html__( 'Portfolio Gallery', 'ova-por' );
	}

	public function get_icon() {
		return 'eicon-gallery-grid';
	}

	public function get_categories() {
		return [ 'ovatheme_portfolio' ];
	}

	public function get_script_depends() {
		wp_enqueue_style('fancybox', OVAPOR_PLUGIN_URI.'/assets/libs/fancybox/fancybox.css');
		wp_enqueue_script('fancybox', OVAPOR_PLUGIN_URI.'/assets/libs/fancybox/fancybox.umd.js', array('jquery'),null,true);

		wp_enqueue_script( 'ovapor-gallery', OVAPOR_PLUGIN_URI.'assets/js/elementor/portfolio-gallery.js' );

		return [''];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'ovapor-gallery', OVAPOR_PLUGIN_URI.'/assets/css/elementor/portfolio-gallery.css', array(), null);
		return [];
	}

	protected function ova_categories() {

		$args = array(
			'taxonomy' => 'cat_por',
			'orderby' => 'name',
			'order'   => 'ASC'
		);

		$categories = get_categories($args);
		$cate_array = array( 'all' => esc_html__( 'All categories', 'ova-por' ) );

		if ($categories) {
			foreach ( $categories as $cate ) {
				$cate_array[$cate->slug] = $cate->cat_name;
			}
		}
		return $cate_array;
	}

	protected function register_controls() {

		/* Portfolio */
		$this->start_controls_section(
				'section_portfolio',
				[
					'label' => esc_html__( 'Portfolio', 'ova-por' ),
				]
			);

			$categories = $this->ova_categories();

			$this->add_control(
				'cate',
				[
					'label'   => esc_html__( 'Category', 'ova-por' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'all',
					'options' => $categories,
				]
			);

			$this->add_control(
				'posts_per_page',
				[
					'label'   => esc_html__( 'Total', 'ova-por' ),
					'type'    => Controls_Manager::NUMBER,
					'default' => 6
				]
			);

			$this->add_control(
				'order',
				[
					'label' => esc_html__( 'Order', 'ova-por' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'DESC',
					'options' => [
						'ASC' => esc_html__( 'Ascending', 'ova-por' ),
						'DESC' => esc_html__( 'Descending', 'ova-por' ),
					],
				]
			);

			$this->add_control(
				'order_by',
				[
					'label' => esc_html__( 'OrderBy Post', 'ova-por' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'ID',
					'options' => [
						'ID'  	=> esc_html__( 'ID', 'ova-por' ),
						'date'  => esc_html__( 'Date', 'ova-por' ),
						'title' => esc_html__( 'Title', 'ova-por' ),
						'rand'  => esc_html__( 'Random', 'ova-por' ),
						'ova_por_met_order_por' => esc_html__( 'Custom Order', 'ova-por' ),
					],
				]
			);

			$this->add_control(
				'show_icon',
				[
					'label' => esc_html__( 'Show Icon', 'ova-por' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-por' ),
					'label_off' => esc_html__( 'Hide', 'ova-por' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_title',
				[
					'label' => esc_html__( 'Show Title', 'ova-por' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-por' ),
					'label_off' => esc_html__( 'Hide', 'ova-por' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_link_to',
				[
					'label' => esc_html__( 'Show Link to Detail', 'ova-por' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-por' ),
					'label_off' => esc_html__( 'Hide', 'ova-por' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

		$this->end_controls_section();

		/* General */
		$this->start_controls_section(
				'general_style_section',
				[
					'label' => esc_html__( 'General', 'ova-por' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_control(
				'item_bg_color',
				[
					'label' => esc_html__( 'Background', 'ova-por' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-por-gallery .grid .grid-item .gallery-fancybox .gallery-container:before' => 'background: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/* Icon */
		$this->start_controls_section(
				'icon_style_section',
				[
					'label' => esc_html__( 'Icon', 'ova-por' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'icon_margin',
				[
					'label' => esc_html__( 'Margin', 'ova-por' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-por-gallery .grid .grid-item .gallery-fancybox .gallery-container .gallery-icon .icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'icon_color',
				[
					'label' => esc_html__( 'Color', 'ova-por' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-por-gallery .grid .grid-item .gallery-fancybox .gallery-container .gallery-icon .icon' => 'border-color: {{VALUE}}',
						'{{WRAPPER}} .ova-por-gallery .grid .grid-item .gallery-fancybox .gallery-container .gallery-icon .icon i' => 'color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/* Title */
		$this->start_controls_section(
				'title_style_section',
				[
					'label' => esc_html__( 'Title', 'ova-por' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'title_margin',
				[
					'label' => esc_html__( 'Margin', 'ova-por' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-por-gallery .grid .grid-item .gallery-fancybox .gallery-container .gallery-content .gallery-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'title_typography',
					'selector' => '{{WRAPPER}} .ova-por-gallery .grid .grid-item .gallery-fancybox .gallery-container .gallery-content .gallery-title',
				]
			);

			$this->add_control(
				'title_color',
				[
					'label' => esc_html__( 'Color', 'ova-por' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-por-gallery .grid .grid-item .gallery-fancybox .gallery-container .gallery-content .gallery-title' => 'color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();
	}

	protected function render() {

		$settings = $this->get_settings();

		$template = apply_filters( 'el_elementor_ova_por_gallery', 'elementor/ova_por_gallery.php' );

		ob_start();
		ovapor_get_template( $template, $settings );
		echo ob_get_clean();
	}

}
