<?php defined( 'ABSPATH' ) || exit();

if( !class_exists( 'OVAPOR_assets' ) ){
	class OVAPOR_assets{

		public function __construct(){
			add_action( 'wp_enqueue_scripts', array( $this, 'ovapor_enqueue_scripts' ), 10, 0 );
		}

		public function ovapor_enqueue_scripts(){

			if ( is_post_type_archive( array( 'ova_por' ) ) || is_tax( 'cat_por' ) ){
				// Isotope
				wp_enqueue_script( 'ovapor_isotope', OVAPOR_PLUGIN_URI.'assets/libs/isotope/isotope.pkgd.min.js', array('jquery'), false, true );
				wp_enqueue_script('imagesloaded');

				wp_enqueue_script( 'ovapor_script', OVAPOR_PLUGIN_URI.'assets/js/frontend/ovapor-script.js' );
				wp_localize_script( 'ovapor_script', 'ajax_object', array('ajax_url' => admin_url('admin-ajax.php')));	
				wp_enqueue_style( 'ovapor_style', OVAPOR_PLUGIN_URI.'assets/css/frontend/ovapor-style.css' );	
			}

			if ( is_singular( 'ova_por' ) ){
				wp_enqueue_style( 'ova-por-fancybox', OVAPOR_PLUGIN_URI.'/assets/libs/fancybox/fancybox.css', array(), null);
				wp_enqueue_script( 'ova-por-fancybox', OVAPOR_PLUGIN_URI.'/assets/libs/fancybox/fancybox.umd.js', [ 'jquery' ],false,true);

				wp_enqueue_script( 'ovapor_single_script', OVAPOR_PLUGIN_URI.'assets/js/frontend/ovapor-single-script.js' );
				wp_enqueue_style( 'ovapor_style', OVAPOR_PLUGIN_URI.'assets/css/frontend/ovapor-style.css' );
			}		

		}


	}
	new OVAPOR_assets();
}
