<?php if ( !defined( 'ABSPATH' ) ) exit();

	get_header();

	$type 		 		 = 'type1';
    $show_sidebar	 	 = get_theme_mod( 'archive_donation_show_sidebar', 'no' );
	$layout 	 		 = get_theme_mod( 'archive_donation_column', 'three_column' );
	$posts_per_page 	 = get_theme_mod( 'archive_donation_posts_per_page', 6 );
	$show_category		 = get_theme_mod( 'show_category_donation', 'yes' );
	$show_excerpt		 = get_theme_mod( 'show_excerpt_donation', 'yes' );
	$limit_text		     = get_theme_mod( 'number_text_donation', 12 );
	
	if ( isset($_GET['show_sidebar']) ) {
		$show_sidebar   = $_GET['show_sidebar'];
	}

	if ( isset($_GET['type']) ) {
		$type  			= $_GET['type'];
	}

	if ( isset($_GET['layout']) ) {
		$layout 		= $_GET['layout'];
	}

	$paged   	= ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;

	$args_base  = array(
		'post_type' => 'give_forms',
		'posts_per_page' => $posts_per_page,
		'paged' 	=> $paged,
	);
    
    // Check if is_category page
	if( is_tax( 'give_forms_category' ) ||  get_query_var( 'give_forms_category' ) != '' ){

        $id 		= get_the_ID(); 

        $give_type  = get_the_terms( $id, 'give_forms_category') ? get_the_terms( $id, 'give_forms_category') : '' ;

		if ( $give_type != '' ) {
			
			$value_give_type = get_queried_object()->term_id;

			$args_base = array(
				'post_type' => 'give_forms',
				'paged' => $paged,
				'tax_query' => array(
					array(
						'taxonomy' => 'give_forms_category',
						'field'    => 'term_id',
						'terms'    => $value_give_type,
					),
				),
			);
		} 
	}

	$give_donation = new WP_Query( $args_base );

?>

<div class="container row_site">

	<div class="container_site archive_give_donation content_archive_<?php echo esc_attr($type); ?>">

		<div class="summary">

			<div class="wrap_summary <?php echo esc_attr($layout); ?>">
				<?php if($give_donation->have_posts() ) : while ( $give_donation->have_posts() ) : $give_donation->the_post(); ?>

					<?php ob_start(); 

				    	get_template_part( 'give/template-parts/item-give', null, array('show_category' => $show_category, 'limit_text' => $limit_text, 'show_excerpt' => $show_excerpt, 'type' => $type) );

					echo ob_get_clean(); ?>

				<?php endwhile; else: ?>

					<div class="search_not_found">
						<?php esc_html_e( 'Not Found Give Donation', 'gimont' ); ?>
					</div>

				<?php endif; wp_reset_postdata(); ?>

			</div>

			<div class="pagination-wrapper">
				<?php gimont_give_pagination_theme($give_donation); ?>
			</div>		
			
		</div>

		<?php if( $show_sidebar == "yes" ) { ?>

    		<div class="sidebar sidebar_give">
				<?php
					do_action( 'give_before_single_form_summary' );
				?>
			</div>

	    <?php } ?>

	</div>

</div>


<?php get_footer(); ?>