<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
use Elementor\Group_Control_Border;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Gimont_Elementor_Contact_Info extends Widget_Base {

	public function get_name() {
		return 'gimont_elementor_contact_info';
	}

	public function get_title() {
		return esc_html__( 'Contact Info', 'gimont' );
	}

	public function get_icon() {
		return 'eicon-email-field';
	}

	public function get_categories() {
		return [ 'gimont' ];
	}

	public function get_script_depends() {
		return [ '' ];
	}
	
	// Add Your Controll In This Function
	protected function register_controls() {

		/* Content */
		$this->start_controls_section(
				'section_content',
				[
					'label' => esc_html__( 'Content', 'gimont' ),
				]
			);

			$this->add_control(
				'template',
				[
					'label' => esc_html__( 'Template', 'gimont' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'template_1',
					'options' => [
						'template_1' => esc_html__( 'Template 1', 'gimont' ),
						'template_2' => esc_html__( 'Template 2', 'gimont' ),
					],
				]
			);

			$this->add_control(
				'main_icon',
				[
					'label' => esc_html__( 'Category Icon', 'gimont' ),
					'type' => \Elementor\Controls_Manager::ICONS,
				]
			);

			$this->add_control(
				'title_category',
				[
					'label' 	=> esc_html__( 'Category Title', 'gimont' ),
					'type' 		=> Controls_Manager::TEXT,
				]
			);

			$repeater = new \Elementor\Repeater();

			$repeater->add_control(
				'icon',
				[
					'label' => esc_html__( 'Icon', 'gimont' ),
					'type' => \Elementor\Controls_Manager::ICONS,
					'default' => [
						'value' => 'gimonticon gimonticon-phone-call',
						'library' => 'all',
					],
				]
			);

			$repeater->add_control(
				'label',
				[
					'label' => esc_html__( 'Label', 'gimont' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__( 'Have any question?', 'gimont' ),
				]
			);

			$repeater->add_control(
				'option',
				[
					'label' => esc_html__( 'Option', 'gimont' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'phone',
					'options' => [
						'phone' => esc_html__( 'Phone', 'gimont' ),
						'email' => esc_html__( 'Email', 'gimont' ),
						'map'  => esc_html__( 'Link', 'gimont' ),
					],
				]
			);

			$repeater->add_control(
				'link',
				[
					'label' => esc_html__( 'Link', 'gimont' ),
					'type' => \Elementor\Controls_Manager::URL,
					'placeholder' => esc_html__( 'https://your-link.com', 'gimont' ),
					'options' => [ 'url', 'is_external', 'nofollow' ],
					'default' => [
						'url' => '+230009850',
						'is_external' => true,
						'nofollow' => false,
					],
					'label_block' => true,
				]
			);

			$repeater->add_control(
				'text',
				[
					'label' => esc_html__( 'Text', 'gimont' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__( 'Free +23 (000)-9850', 'gimont' ),
					'label_block' => true,
				]
			);

			$this->add_control(
				'list',
				[
					'label' => esc_html__( 'Contact List', 'gimont' ),
					'type' => \Elementor\Controls_Manager::REPEATER,
					'fields' => $repeater->get_controls(),
					'default' => [
						[
							'icon' => [
								'value' => 'gimonticon gimonticon-phone-call',
								'library' => 'all',
							],
							'label' => esc_html__( 'Have any question?', 'gimont' ),
							'option' => 'phone',
							'link' => [
								'url' => '+230009850',
							],
							'text' => esc_html__( 'Free +23 (000)-9850', 'gimont' ),
						],
						[
							'icon' => [
								'value' => 'ovaicon ovaicon-email',
								'library' => 'all',
							],
							'label' => esc_html__( 'Write email', 'gimont' ),
							'option' => 'email',
							'link' => [
								'url' => 'needhelp@company.com',
							],
							'text' => esc_html__( 'needhelp@company.com', 'gimont' ),
						],
						[
							'icon' => [
								'value' => 'gimonticon gimonticon-location',
								'library' => 'all',
							],
							'label' => esc_html__( 'Visit anytime', 'gimont' ),
							'option' => 'map',
							'link' => [
								'url' => 'https://goo.gl/maps/DP8ugG7n1aHTdAt89',
							],
							'text' => esc_html__( '30 broklyn gold street. New York', 'gimont' ),
						],
					],
					'title_field' => '{{{ label }}}',
				]
			);

		$this->end_controls_section();

		/* Icon */
		$this->start_controls_section(
				'icon_style_section',
				[
					'label' => esc_html__( 'Icon', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'icon_margin',
				[
					'label' => esc_html__( 'Margin', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-contact-info .icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'icon_bor_radius',
				[
					'label' => esc_html__( 'Border Radius', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-contact-info .icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'icon_box_size',
				[
					'label' => esc_html__( 'Box Size', 'gimont' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 100,
							'step' => 1,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .ova-contact-info .icon' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'icon_size',
				[
					'label' => esc_html__( 'Size', 'gimont' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 100,
							'step' => 1,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .ova-contact-info .icon i' => 'font-size: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .ova-contact-info .icon svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'icon_color',
				[
					'label' => esc_html__( 'Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-contact-info .icon i' => 'color: {{VALUE}}',
						'{{WRAPPER}} .ova-contact-info .icon svg' => 'fill: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'icon_background',
				[
					'label' => esc_html__( 'Background', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-contact-info .icon' => 'background: {{VALUE}}',
					],
				]
			);

			 $this->add_group_control(
				\Elementor\Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'icon_box_shadow',
					'label' => esc_html__( 'Box Shadow', 'gimont' ),
					'selector' => '{{WRAPPER}} .ova-contact-info .icon',
				]
			);

		$this->end_controls_section();

		/* Category Title */
		$this->start_controls_section(
				'category_title_section',
				[
					'label' => esc_html__( 'Category Title', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'category_title_typography',
					'selector' => '{{WRAPPER}} .ova-contact-info .top .title-category',
				]
			);

			$this->add_control(
				'category_title_color',
				[
					'label' => esc_html__( 'Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-contact-info .top .title-category' => 'color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/* Label */
		$this->start_controls_section(
				'label_style_section',
				[
					'label' => esc_html__( 'Label', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'label_margin',
				[
					'label' => esc_html__( 'Margin', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-contact-info .info .label' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'label_typography',
					'selector' => '{{WRAPPER}} .ova-contact-info .info .label',
				]
			);

			$this->add_control(
				'label_color',
				[
					'label' => esc_html__( 'Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-contact-info .info .label' => 'color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/* Text */
		$this->start_controls_section(
				'text_style_section',
				[
					'label' => esc_html__( 'Text', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'text_margin',
				[
					'label' => esc_html__( 'Margin', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-contact-info .info .text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'text_typography',
					'selector' => '{{WRAPPER}} .ova-contact-info .info .text,.ova-contact-info .info .text a',
				]
			);

			$this->add_control(
				'text_color',
				[
					'label' => esc_html__( 'Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-contact-info .info .text' => 'color: {{VALUE}}',
						'{{WRAPPER}} .ova-contact-info .info .text a' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'text_hover_color',
				[
					'label' => esc_html__( 'Hover Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-contact-info .info .text a:hover' => 'color: {{VALUE}}',
						'{{WRAPPER}} .ova-contact-info .info .text a::after' => 'background: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();
	}

	// Render Template Here
	protected function render() {
		$settings  = $this->get_settings();

		$template  = $settings['template'];
		$main_icon = $settings['main_icon'];
		$title     = $settings['title_category'];

		$list 			= $settings['list'];

		?>

		<div class="ova-contact-info <?php echo esc_attr( $template ); ?>">

			<?php if ( $main_icon['value'] || $title ): ?>
				<div class="top">
			 		<?php if ( $main_icon['value'] ): ?>
				    	<div class="main-icon">
							<?php \Elementor\Icons_Manager::render_icon( $main_icon, [ 'aria-hidden' => 'true' ] ); ?>
						</div>
					<?php endif;?>

					<?php if($title) { ?>
						<h3 class="title-category"><?php echo esc_html( $title ); ?></h3>
					<?php } ?>
			 	</div>
		 	<?php endif; ?>

			<?php if ( $list ): foreach ( $list as $item ):
				$icon 			= $item['icon'];
				$label 			= $item['label'];
				$text 			= $item['text'];
				$option 		= $item['option'];
				$link 			= $item['link'];
				$link_prefix 	= '';
				$target 		= $link['is_external'] 	? 'target="_blank"' : '';
				$nofollow 		= $link['nofollow'] 	? 'rel="nofollow"' 	: '';
				$title 			= $text;
				if ( $option == 'phone' ) {
					$link_prefix 	= 'tel:';
					$title 			= 'phone';
				}
				if ( $option == 'email' ) {
					$link_prefix 	= 'mailto:';
					$title 			= 'email';
				}
			?>
				
				<div class="item">

					<div class="icon">
						<?php \Elementor\Icons_Manager::render_icon( $icon, [ 'aria-hidden' => 'true' ] ); ?>
					</div>

					<div class="info">
						<span class="label"><?php echo esc_html( $label ); ?></span>

						<h3 class="text">
							<?php if ( $link && $link['url'] ): ?>
								<a href="<?php echo esc_url( $link_prefix . '' . $link['url'] ); ?>"
									title="<?php echo esc_attr( $title ); ?>"
									<?php printf('%1$s %2$s', $target, $nofollow ); ?>>
									<?php echo esc_html( $text ); ?>
								</a>
							<?php else: ?>
								<?php echo esc_html( $text ); ?>
							<?php endif; ?>
						</h3>
						
					</div>

				</div>

			<?php endforeach; endif;  ?>

		</div>

		<?php
	}

	
}
$widgets_manager->register( new Gimont_Elementor_Contact_Info() );