<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
use Elementor\Group_Control_Border;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Gimont_Elementor_Icon_Box_Slide extends Widget_Base {

	public function get_name() {
		return 'gimont_elementor_icon_box_slide';
	}

	public function get_title() {
		return esc_html__( 'Ova Icon Box Slide', 'gimont' );
	}

	public function get_icon() {
		return 'eicon-carousel';
	}

	public function get_categories() {
		return [ 'gimont' ];
	}

	public function get_script_depends() {
		return [ 'gimont-elementor-icon-box-slide' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'gimont-elementor-icon-box-slide', GIMONT_URI.'/assets/scss/elementor/icons/icon-box-slide.css' );
		return [];
	}
	
	// Add Your Controll In This Function
	protected function register_controls() {

		/* Content */
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Content', 'gimont' ),
			]
		);

			$this->add_control(
				'template',
				[
					'label' => esc_html__( 'Template', 'gimont' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'template_1',
					'options' => [
						'template_1' => esc_html__( 'Template 1', 'gimont' ),
						'template_2' => esc_html__( 'Template 2', 'gimont' ),
					],
				]
			);

			$repeater = new \Elementor\Repeater();

			$repeater->add_control(
				'link',
				[
					'label' => esc_html__( 'Link', 'gimont' ),
					'type' => \Elementor\Controls_Manager::URL,
					'placeholder' => esc_html__( 'https://your-link.com', 'gimont' ),
					'options' => [ 'url', 'is_external', 'nofollow' ],
					'default' => [
						'url' => '#',
						'is_external' => false,
						'nofollow' => false,
					],
					'label_block' => true,
				]
			);

			$repeater->add_control(
				'image',
				[
					'label'   => esc_html__( 'Image on Hover (Template 2)', 'gimont' ),
					'type'    => \Elementor\Controls_Manager::MEDIA,
					'default' => [
						'url' => Utils::get_placeholder_image_src(),
					],
				]
			);

			$repeater->add_control(
				'icon',
				[
					'label' => esc_html__( 'Icon', 'gimont' ),
					'type' => \Elementor\Controls_Manager::ICONS,
					'default' => [
						'value' => 'flaticon flaticon-healthcare-1',
						'library' => 'all',
					],
				]
			);

			$repeater->add_control(
				'title',
				[
					'label' => esc_html__( 'Title', 'gimont' ),
					'type' => \Elementor\Controls_Manager::TEXTAREA,
					'default' => esc_html__( 'Medical and Health Care Centers', 'gimont' ),
					'rows' => 3,
				]
			);

			$repeater->add_control(
				'desc',
				[
					'label' => esc_html__( 'Description', 'gimont' ),
					'type' => \Elementor\Controls_Manager::TEXTAREA,
					'rows' => 5,
					'default' => esc_html__( 'There are many variations of passages of Ips available but the majority', 'gimont' ),
				]
			);

			$repeater->add_control(
				'text_button',
				[
					'label' => esc_html__( 'Text Button', 'gimont' ),
					'type' => \Elementor\Controls_Manager::TEXT,
				]
			);

			$this->add_control(
				'tab_item',
				[
					'label' => esc_html__( 'Items', 'gimont' ),
					'type' => \Elementor\Controls_Manager::REPEATER,
					'fields' => $repeater->get_controls(),
					'default' => [
						[
							'title' => esc_html__( 'Medical and Health Care Centers', 'gimont' ),
						],
						[
							'icon' => [
								'value' => 'flaticon flaticon-development',
							],
							'title' => esc_html__( 'Economic Stability and Development', 'gimont' ),
						],
						[
							'icon' => [
								'value' => 'flaticon flaticon-traffic-lights',
							],
							'title' => esc_html__( 'City Traffic and Parking Zone', 'gimont' ),
						],
						[
							'icon' => [
								'value' => 'flaticon flaticon-playground',
							],
							'title' => esc_html__( 'Parks, Fields and Recreations', 'gimont' ),
						],
						[
							'icon' => [
								'value' => 'flaticon flaticon-graduation',
							],
							'title' => esc_html__( 'Educational reform', 'gimont' ),
						],
					],
					'title_field' => '{{{ title }}}',
				]
			);

		$this->end_controls_section();

		/* Additional Options */
		$this->start_controls_section(
				'section_additional_options',
				[
					'label' => esc_html__( 'Additional Options', 'gimont' ),
				]
			);

			$this->add_control(
				'margin_items',
				[
					'label'   => esc_html__( 'Margin Right Items', 'gimont' ),
					'type'    => \Elementor\Controls_Manager::NUMBER,
					'default' => 30,
				]
				
			);

			$this->add_control(
				'item_number',
				[
					'label'       => esc_html__( 'Item Number', 'gimont' ),
					'type'        => \Elementor\Controls_Manager::NUMBER,
					'description' => esc_html__( 'Number Item', 'gimont' ),
					'default'     => 4,
				]
			);

			$this->add_control(
				'slides_to_scroll',
				[
					'label'       => esc_html__( 'Slides to Scroll', 'gimont' ),
					'type'        => \Elementor\Controls_Manager::NUMBER,
					'description' => esc_html__( 'Set how many slides are scrolled per swipe.', 'gimont' ),
					'default'     => 1,
				]
			);

			$this->add_control(
				'pause_on_hover',
				[
					'label'   => esc_html__( 'Pause on Hover', 'gimont' ),
					'type'    => \Elementor\Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'gimont' ),
						'no'  => esc_html__( 'No', 'gimont' ),
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'infinite',
				[
					'label'   => esc_html__( 'Infinite Loop', 'gimont' ),
					'type'    => \Elementor\Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'gimont' ),
						'no'  => esc_html__( 'No', 'gimont' ),
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'autoplay',
				[
					'label'   => esc_html__( 'Autoplay', 'gimont' ),
					'type'    => \Elementor\Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'gimont' ),
						'no'  => esc_html__( 'No', 'gimont' ),
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'autoplay_speed',
				[
					'label'     => esc_html__( 'Autoplay Speed', 'gimont' ),
					'type'      => \Elementor\Controls_Manager::NUMBER,
					'default'   => 3000,
					'step'      => 500,
					'condition' => [
						'autoplay' => 'yes',
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'smartspeed',
				[
					'label'   => esc_html__( 'Smart Speed', 'gimont' ),
					'type'    => \Elementor\Controls_Manager::NUMBER,
					'default' => 500,
				]
			);

			$this->add_control(
				'dot_control',
				[
					'label'   => esc_html__( 'Show Dots', 'gimont' ),
					'type'    => \Elementor\Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'gimont' ),
						'no'  => esc_html__( 'No', 'gimont' ),
					],
					'frontend_available' => true,
				]
			);

		$this->end_controls_section();

		/* Items */
		$this->start_controls_section(
				'item_style_section',
				[
					'label' => esc_html__( 'Items', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'item_padding',
				[
					'label' => esc_html__( 'Padding', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-icon-box-slide .card' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->start_controls_tabs(
					'item_style_tabs'
				);

				$this->start_controls_tab(
						'item_style_normal_tab',
						[
							'label' => esc_html__( 'Normal', 'gimont' ),
						]
					);

					$this->add_group_control(
						\Elementor\Group_Control_Box_Shadow::get_type(),
						[
							'name' => 'item_box_shadow',
							'selector' => '{{WRAPPER}} .ova-icon-box-slide .card',
						]
					);

					$this->add_control(
						'item_bg',
						[
							'label' => esc_html__( 'Background', 'gimont' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-icon-box-slide .card' => 'background: {{VALUE}}',
							],
						]
					);

				$this->end_controls_tab();

				$this->start_controls_tab(
						'item_style_hover_tab',
						[
							'label' => esc_html__( 'Hover', 'gimont' ),
						]
					);

					$this->add_group_control(
						\Elementor\Group_Control_Box_Shadow::get_type(),
						[
							'name' => 'item_box_shadow_hover',
							'selector' => '{{WRAPPER}} .ova-icon-box-slide .item-box:hover .card',
						]
					);

					$this->add_control(
						'item_bg_hover',
						[
							'label' => esc_html__( 'Background', 'gimont' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-icon-box-slide .item-box:hover .card' => 'background: {{VALUE}}',
							],
						]
					);

				$this->end_controls_tab();

			$this->end_controls_tabs();

		$this->end_controls_section();

		/* Number */
		$this->start_controls_section(
			'number_style_section',
			[
				'label' => esc_html__( 'Number', 'gimont' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				'condition' => [
					'template' => 'template_1'
				]
			]
		);

			$this->add_responsive_control(
				'number_margin',
				[
					'label' => esc_html__( 'Margin', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-icon-box-slide .card .number' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'number_typography',
					'selector' => '{{WRAPPER}} .ova-icon-box-slide .card .number',
				]
			);

			$this->add_control(
				'number_color',
				[
					'label' => esc_html__( 'Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-icon-box-slide .card .number' => 'color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/* Icon */
		$this->start_controls_section(
				'icon_style_section',
				[
					'label' => esc_html__( 'Icon', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'icon_margin',
				[
					'label' => esc_html__( 'Margin', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-icon-box-slide .card .icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'icon_size',
				[
					'label' => esc_html__( 'Size', 'gimont' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 100,
							'step' => 5,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .ova-icon-box-slide .card .icon svg' => 'width: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .ova-icon-box-slide .card .icon i' => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'icon_color',
				[
					'label' => esc_html__( 'Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-icon-box-slide .card .icon i' => 'color: {{VALUE}}',
						'{{WRAPPER}} .ova-icon-box-slide .card .icon svg' => 'fill: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/* Title */
		$this->start_controls_section(
				'title_style_section',
				[
					'label' => esc_html__( 'Title', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'title_margin',
				[
					'label' => esc_html__( 'Margin', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-icon-box-slide .card .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'title_typography',
					'selector' => '{{WRAPPER}} .ova-icon-box-slide .card .title',
				]
			);

			$this->add_control(
				'title_color',
				[
					'label' => esc_html__( 'Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-icon-box-slide .card .title' => 'color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/* Description */
		$this->start_controls_section(
				'desc_style_section',
				[
					'label' => esc_html__( 'Description', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'desc_margin',
				[
					'label' => esc_html__( 'Margin', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-icon-box-slide .card .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'desc_typography',
					'selector' => '{{WRAPPER}} .ova-icon-box-slide .card .desc',
				]
			);

			$this->add_control(
				'desc_color',
				[
					'label' => esc_html__( 'Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-icon-box-slide .card .desc' => 'color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

	}

	// Render Template Here
	protected function render() {
		$settings = $this->get_settings();

		$template = $settings['template'];
		$tab_item = $settings['tab_item'];
		
		$data_options['items']              = $settings['item_number'];
		$data_options['slideBy']            = $settings['slides_to_scroll'];
		$data_options['margin']             = $settings['margin_items'];
		$data_options['autoplayHoverPause'] = $settings['pause_on_hover'] === 'yes' ? true : false;
		$data_options['loop']               = $settings['infinite'] === 'yes' ? true : false;
		$data_options['autoplay']           = $settings['autoplay'] === 'yes' ? true : false;
		$data_options['autoplayTimeout']    = $settings['autoplay_speed'];
		$data_options['smartSpeed']         = $settings['smartspeed'];
		$data_options['dots']               = $settings['dot_control'] === 'yes' ? true : false;
		$data_options['rtl']				= is_rtl() ? true : false;

		?>

		<div class="ova-icon-box-slide <?php echo esc_attr( $template ); ?>">

			<div class="icon-box-slide owl-carousel owl-theme" data-options="<?php echo esc_attr(json_encode($data_options)) ?>">

				<?php if ( $tab_item ): foreach ( $tab_item as $key => $item ):
					$title 		 = $item['title'];
					$desc 		 = $item['desc'];
					$text_button = $item['text_button'];
					$link 		 = $item['link'];
					$nofollow 	 = $link['nofollow'] 	? 'rel="nofollow"' 	: '';
					$target 	 = $link['is_external'] 	? 'target="_blank"' : '';
					$number 	 = ( $key + 1 ) < 10 ? '0' . ( $key + 1 ) : ( $key + 1 );

					$image_url 	= $item['image']['url'] ? $item['image']['url'] : '';
					$image_alt 	= $title;

					if ( $item['image']['id'] ) {
						$image_alt = get_post_meta( $item['image']['id'] , '_wp_attachment_image_alt', true );
					}
				?>
					<div class="item-box">
						<div class="card">

							<?php if( $template == "template_1" ) : ?>
							<span class="number"><?php echo esc_html( $number ); ?></span>
							<?php endif; ?>

							<?php if ( $item['icon']['value'] ): ?>
								<div class="icon">
									<?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
								</div>
							<?php endif; ?>

							<?php if ( $title ): ?>
								<?php if ( $link['url'] ): ?>
									<a href="<?php echo esc_url( $link['url'] ); ?>" title="<?php echo esc_attr( $title ); ?>" <?php printf( '%1$s %2$s', $nofollow, $target ); ?>>
										<h3 class="title"><?php echo esc_html( $title ); ?></h3>
									</a>
								<?php else: ?>
									<h3 class="title"><?php echo esc_html( $title ); ?></h3>
								<?php endif; ?>
							<?php endif; ?>

							<?php if ( $desc ): ?>
								<p class="desc"><?php echo esc_html( $desc ); ?></p>
							<?php endif; ?>

							<?php if ( $text_button && $link['url']  ): ?>
								<a class="details-button" href="<?php echo esc_url( $link['url'] ); ?>" title="<?php echo esc_attr( $title ); ?>" <?php printf( '%1$s %2$s', $nofollow, $target ); ?>>
									<span class="text-button"><?php echo esc_html($text_button);?></span>
									<i aria-hidden="true" class="flaticonnew- flaticon-new-right"></i>
								</a>
							<?php endif; ?>
						</div>
						<?php if( $template == "template_2" ) { ?>
							<div class="card card-hover">
								<div class="info">
									<?php if ( $title ): ?>
										<?php if ( $link['url'] ): ?>
											<a href="<?php echo esc_url( $link['url'] ); ?>" title="<?php echo esc_attr( $title ); ?>" <?php printf( '%1$s %2$s', $nofollow, $target ); ?>>
												<h3 class="title"><?php echo esc_html( $title ); ?></h3>
											</a>
										<?php else: ?>
											<h3 class="title"><?php echo esc_html( $title ); ?></h3>
										<?php endif; ?>
									<?php endif; ?>

									<?php if ( $desc ): ?>
										<p class="desc"><?php echo esc_html( $desc ); ?></p>
									<?php endif; ?>
								</div>

								<?php if ( $image_url ): ?>
									<?php if ( $link['url'] ): ?>
									<a href="<?php echo esc_url( $link['url'] ); ?>" title="<?php echo esc_attr( $title ); ?>" <?php printf( '%1$s %2$s', $nofollow, $target ); ?>>
									<?php endif; ?>
										<img src="<?php echo esc_url( $image_url ); ?>" alt="<?php echo esc_attr( $image_alt ); ?>">
									<?php if ( $link['url'] ): ?>
									</a>
									<?php endif; ?>
								<?php endif; ?>
							</div>
						<?php } ?>
					</div>
				<?php endforeach;  endif;  ?>

			</div>

		</div>

		<?php
	}

	
}
$widgets_manager->register( new Gimont_Elementor_Icon_Box_Slide() );