<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


class Gimont_Elementor_Ova_Search_Popup extends Widget_Base {

	public function get_name() {
		return 'gimont_elementor_ova_search_popup';
	}

	public function get_title() {
		return esc_html__( 'Search Popup', 'gimont' );
	}

	public function get_icon() {
		return 'eicon-search-bold';
	}

	public function get_categories() {
		return [ 'hf' ];
	}

	public function get_script_depends() {
		return [ 'gimont-elementor-search-popup' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_icon_search',
			[
				'label' => esc_html__( 'Icon Search', 'gimont' ),
			]
		);

		    $this->add_control(
				'size_icon',
				[
					'label' => esc_html__( 'Size Icon', 'gimont' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 50,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'default' => [
						'unit' => 'px',
					],
					'selectors' => [
						'{{WRAPPER}} .ova_wrap_search_popup i' => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);
			
			$this->add_control(
				'color_icon_search',
				[
					'label' => esc_html__( 'Icon Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova_wrap_search_popup i' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'color_hover_icon_search',
				[
					'label' => esc_html__( 'Icon Color Hover', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova_wrap_search_popup i:hover' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'bgcolor_icon_search',
				[
					'label' => esc_html__( 'Background Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova_wrap_search_popup i.front_search' => 'background-color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'bgcolor_hover_icon_search',
				[
					'label' => esc_html__( 'Background Color Hover', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova_wrap_search_popup i.front_search:hover' => 'background-color: {{VALUE}}',
					],
				]
			);

			$this->add_responsive_control(
			  	'icon_search_padding',
			  	[
				  	'label' => esc_html__( 'Padding', 'gimont' ),
				  	'type' => Controls_Manager::DIMENSIONS,
				  	'size_units' => [ 'px', 'em', '%' ],
				  	'selectors' => [
					  	'{{WRAPPER}} .ova_wrap_search_popup i.front_search' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				  	],
			  	]
		  	);

		  	$this->add_group_control(
	            \Elementor\Group_Control_Border::get_type(), [
	                'name' 		=> 'icon_search_border',
	                'selector' 	=> '{{WRAPPER}} .ova_wrap_search_popup i.front_search', 
	            ]
	        );

		$this->end_controls_section();

		$this->start_controls_section(
			'section_search_popup_button',
			[
				'label' => esc_html__( 'Search Popup Button', 'gimont' ),
			]
		);
			
			$this->add_control(
				'bgcolor_search_popup_button',
				[
					'label' => esc_html__( 'Background Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova_wrap_search_popup .ova_search_popup .container .search-form .search-submit' => 'background-color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'bgcolor_hover_icon_search_popup',
				[
					'label' => esc_html__( 'Background Color Hover', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova_wrap_search_popup .ova_search_popup .container .search-form .search-submit:hover' => 'background-color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

	}

	protected function render() {
		?>

			<div class="ova_wrap_search_popup">
				<i class="front_search gimonticon gimonticon-search-interface-symbol"></i>
				<div class="ova_search_popup">
					<div class="search-popup__overlay"></div>
					<div class="container">
						<form role="search" method="get" class="search-form" action="<?php echo home_url( '/' ); ?>">
						        <input type="search" class="search-field" placeholder="<?php esc_attr_e( 'Search …', 'gimont' ); ?>" value="<?php echo get_search_query(); ?>" name="s" title="<?php esc_attr_e( 'Search for:', 'gimont' ) ?>" />
				   			 	<button type="submit" class="search-submit" aria-label="<?php esc_attr_e( 'Search', 'gimont' ); ?>">
				   			 		<i class="gimonticon gimonticon-search-interface-symbol"></i>
				   			 	</button>
						</form>									
					</div>
				</div>
			</div>

		<?php
	}

}

$widgets_manager->register( new Gimont_Elementor_Ova_Search_Popup() );