<?php
namespace ova_sev_elementor\Widgets;

use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class ova_sev_search_ajax extends Widget_Base {

	public function get_name() {
		return 'ova_sev_search_ajax';
	}

	public function get_title() {
		return esc_html__( 'Service Search Ajax', 'ova-sev' );
	}

	public function get_icon() {
		return 'eicon-search-results';
	}

	public function get_categories() {
		return [ 'ovatheme_service' ];
	}

	public function get_script_depends() {
		// Select2
		wp_enqueue_script( 'ova_sev_select2', OVASEV_PLUGIN_URI.'assets/libs/select2/select2.min.js', array('jquery'), false, true );
		wp_enqueue_style( 'ova_sev_select2', OVASEV_PLUGIN_URI.'assets/libs/select2/select2.min.css', array(), null );

		wp_enqueue_script('ova_sev_script', OVASEV_PLUGIN_URI.'assets/js/ova-sev.js', array('jquery'), false, true);
		wp_localize_script( 'ova_sev_script', 'Placeholder', array('name' => esc_html__( 'Name', 'ova-sev' )) );
		wp_localize_script( 'ova_sev_script', 'ova_sev_ajax_object', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );
		return [ '' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'ovasev_style', OVASEV_PLUGIN_URI.'assets/css/frontend/ovasev-style.css' );
		return [];
	}

	protected function register_controls() {

		/* Content */
		$this->start_controls_section(
				'content_section',
				[
					'label' => esc_html__( 'Content', 'ova-sev' ),
					'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				]
			);

			$this->add_control(
				'posts_per_page',
				[
					'label'   		=> esc_html__( 'Posts Per Page', 'ova-sev' ),
					'type'    		=> \Elementor\Controls_Manager::NUMBER,
					'default'       => 9
				]
			);

			$this->add_control(
				'number_column',
				[
					'label' => esc_html__( 'Number Column', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'three_columns',
					'options' => [
						'two_columns' => esc_html__( '2 Columns', 'ova-sev' ),
						'three_columns' => esc_html__( '3 Columns', 'ova-sev' ),
						'four_columns' => esc_html__( '4 Columns', 'ova-sev' ),
					],
				]
			);

			$this->add_control(
				'order',
				[
					'label' => esc_html__( 'Order', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'DESC',
					'options' => [
						'ASC' => esc_html__( 'Ascending', 'ova-sev' ),
						'DESC' => esc_html__( 'Descending', 'ova-sev' ),
					],
				]
			);

			$this->add_control(
				'order_by',
				[
					'label' => esc_html__( 'Order By', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'date',
					'options' => [
						'ID'  	=> esc_html__( 'ID', 'ova-sev' ),
						'date'  => esc_html__( 'Date', 'ova-sev' ),
						'title' => esc_html__( 'Title', 'ova-sev' ),
						'rand'  => esc_html__( 'Random', 'ova-sev' ),
						'ova_sev_met_order_sev' => esc_html__( 'Sort Order', 'ova-sev' ),
					],
				]
			);

			$this->add_control(
				'show_search_name',
				[
					'label' => esc_html__( 'Show Search by Name', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-sev' ),
					'label_off' => esc_html__( 'Hide', 'ova-sev' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_search_category',
				[
					'label' => esc_html__( 'Show Search by Category', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-sev' ),
					'label_off' => esc_html__( 'Hide', 'ova-sev' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_total_results',
				[
					'label' => esc_html__( 'Show Total Results', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-sev' ),
					'label_off' => esc_html__( 'Hide', 'ova-sev' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_sort_by',
				[
					'label' => esc_html__( 'Show Sort by', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-sev' ),
					'label_off' => esc_html__( 'Hide', 'ova-sev' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_icon',
				[
					'label' => esc_html__( 'Show Icon', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-sev' ),
					'label_off' => esc_html__( 'Hide', 'ova-sev' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_title',
				[
					'label' => esc_html__( 'Show Title', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-sev' ),
					'label_off' => esc_html__( 'Hide', 'ova-sev' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_link_of_title',
				[
					'label' => esc_html__( 'Show Link of Title', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-sev' ),
					'label_off' => esc_html__( 'Hide', 'ova-sev' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_desc',
				[
					'label' => esc_html__( 'Show Short Description', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-sev' ),
					'label_off' => esc_html__( 'Hide', 'ova-sev' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_button',
				[
					'label' => esc_html__( 'Show Button', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-sev' ),
					'label_off' => esc_html__( 'Hide', 'ova-sev' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);
			
		$this->end_controls_section();

	}


	protected function render() {
		$settings = $this->get_settings_for_display();
		$template = apply_filters( 'el_elementor_ova_sev_search_ajax', 'elementor/ova_sev_search_ajax.php' );

		ob_start();
		ovasev_get_template( $template, $settings );
		echo ob_get_clean();
	}
}
