<?php

if ( !defined( 'ABSPATH' ) ) {
	exit;
}

// query archive
add_action( 'pre_get_posts', 'ova_sev_post_per_page_archive' );
function ova_sev_post_per_page_archive( $query ) {

	if ( ! is_admin() && $query->is_main_query() ) {

		if ( is_post_type_archive( 'ova_sev' ) || is_tax('cat_sev') ) {

			if( $query->is_post_type_archive( 'ova_sev' ) || $query->is_tax('cat_sev') ) {
				$query->set('post_type', array( 'ova_sev' ) );
				$query->set('posts_per_page', get_theme_mod( 'ova_sev_total_record', 9 ) );

				$orderby 	= get_theme_mod( 'ova_sev_orderby', 'ID' );
				$order 		= get_theme_mod( 'ova_sev_order', 'DESC' );

				$query->set('order', $order );

				if ( $orderby === 'ova_sev_met_order_sev' ) {
					$query->set('orderby', 'meta_value_num' );
					$query->set('meta_type', 'NUMERIC' );
					$query->set('meta_key', 'ova_sev_met_order_sev' );
				} else {
					$query->set('orderby', $orderby );
				}
			}
		}

	}

}

// query get data for element
function ova_sev_query($args) {

	$order 			= $args['order'];
	$order_by 		= $args['order_by'];
	$posts_per_page = $args['posts_per_page'];
	$cate 			= $args['cate'];

	$wp_args = array(
		'post_type' 		=> 'ova_sev',
		'post_status' 		=> 'publish',
		'order' 			=> $order,
		'orderby' 			=> $order_by,
		'posts_per_page' 	=> $posts_per_page,
	);

	if ( array_key_exists('offset', $args) ) {
		if ($args['offset'] != -1) {
			$wp_args['offset'] = $args['offset'];
		}
	}

	if ( array_key_exists('cate_name', $args) ) {
		if ( $args['cate_name'] ) {
			$wp_args['s'] = $args['cate_name'];
		}
	}

	if ( $order_by == 'ova_sev_met_order_sev' ) {
		$wp_args['orderby'] 	= 'meta_value_num';
		$wp_args['meta_key'] 	= $order_by;
		$wp_args['meta_type'] 	= 'NUMERIC';
	}

	if ($cate != 'all') {
		$wp_args['tax_query'] = array(
			array(
				'taxonomy'         => 'cat_sev',
				'field'            => 'slug',
				'terms'            => $cate,
				'include_children' => true,
				'operator'         => 'IN',
			),
		);
	}

	return new WP_Query( $wp_args );
}

// pagination ajax
function ova_sev_pagination_ajax($total_pages,$curent_page,$post_per_page,$args,$search_sort){
	if ( $total_pages > 1 ) :
		$page_num_arr = range(1, $total_pages);
	?>
	<div class="ova_sev_pagination_ajax" data-args="<?php echo esc_attr( json_encode($args) ); ?>">
		<nav class="navigation pagination" aria-label="<?php esc_attr_e( 'Pagination', 'ova-sev' ); ?>">
			<div class="nav-links">
				<ul class="page-numbers">
					<?php if ( $curent_page > 1 ):
					 	$offset = $post_per_page * ( max( $curent_page - 1, 1) - 1) == 0 ? -1 : $post_per_page * ( max( $curent_page - 1, 1) - 1);
					?>
						<li>
							<a class="prev page-numbers" href="#" aria-label="<?php esc_attr_e( 'Previous Page', 'ova-sev' ); ?>"
								data-offset="<?php echo esc_attr( $offset ); ?>"
								data-page="<?php echo esc_attr( max( $curent_page - 1, 1) ); ?>">
								<i class="ovaicon-back"></i>
							</a>
						</li>
					<?php endif;
						$first_item = max( $curent_page - 1, 1 );
						$last_item = min( $curent_page + 1, $total_pages );
						if ($curent_page == 1) {
							$last_item = min( $curent_page + 2, $total_pages );
						}
						if ($curent_page == $total_pages) {
							$first_item = max( $curent_page - 2, 1 );
						}
						$sub_page_num_arr = range( $first_item, $last_item );
						foreach ( $sub_page_num_arr as $page_number ):
					?>
						<li>
							<?php if ( $curent_page == $page_number ): ?>
								<span aria-current="page" class="page-numbers current">
									<?php echo esc_html( $page_number ); ?>
								</span>
							<?php else: ?>
								<?php
									$offset = $post_per_page * ($page_number - 1) == 0 ? -1 : $post_per_page * ($page_number - 1);
								?>
							<a href="#" class="page-numbers"
								data-offset="<?php echo esc_attr( $offset ); ?>"
								data-page="<?php echo esc_attr( $page_number ); ?>">
								<?php echo esc_html( $page_number ); ?>
							</a>
							<?php endif; ?>
						</li>
					<?php endforeach; ?>
					<?php if ( $curent_page < $total_pages ): ?>
						<li>
							<a class="next page-numbers" href="#" aria-label="<?php esc_attr_e( 'Next Page', 'ova-sev' ); ?>"
							data-offset="<?php echo esc_attr( $post_per_page * ( min( $curent_page + 1, $total_pages) - 1) ); ?>"
							data-page="<?php echo esc_attr( min( $curent_page + 1, $total_pages) ); ?>"
							data-search_sort="<?php echo esc_attr( $search_sort ); ?>"
							>
							<i class="ovaicon-next"></i>
							</a>
						</li>
					<?php endif; ?>

				</ul>
			</div>
		</nav>
	</div>
	<?php endif;
}

function ova_get_sev_list( $services, $s_sort, $args_show ){
	if ( $services->have_posts() ) : ?>
		<div class="wrap_search_filter">
			<?php if ( $args_show['show_total_results'] == 'yes' ): ?>
				<div class="results_found">
					<?php if ( $services->found_posts == 1 ): ?>
					<span>
						<?php echo sprintf( esc_html__( '%s Result Found', 'ova-sev' ), esc_html( $services->found_posts ) ); ?>
					</span>
					<?php else: ?>
					<span>
						<?php echo sprintf( esc_html__( '%s Results Found', 'ova-sev' ), esc_html( $services->found_posts ) ); ?>
					</span>
					<?php endif; ?>

					<?php if ( 1 == ceil( $services->found_posts/ $services->query_vars['posts_per_page']) && $services->have_posts() ): ?>
						<span>
							<?php echo sprintf( esc_html__( '(Showing 1-%s)', 'ova-sev' ), esc_html( $services->found_posts ) ); ?>
						</span>
					<?php elseif ( !$services->have_posts() ): ?>
						<span></span>
					<?php else: ?>
						<span>
							<?php echo sprintf( esc_html__( '(Showing 1-%s)', 'ova-sev' ), esc_html( $services->query_vars['posts_per_page'] ) ); ?>
						</span>
					<?php endif; ?>
				</div>
			<?php endif; ?>

			<?php if ( $args_show['show_sort_by'] == 'yes' ): ?>
				<div id="search_sort">
					<select name="sort">
						<option value=""><?php esc_html_e( 'Sort By', 'ova-sev' ); ?></option>
						<option value="date-desc" <?php if( $s_sort == 'date-desc' ) echo 'selected'; ?>>
							<?php esc_html_e( 'Newest First', 'ova-sev' ); ?>
						</option>
						<option value="date-asc" <?php if( $s_sort == 'date-asc' ) echo 'selected'; ?>>
							<?php esc_html_e( 'Oldest First', 'ova-sev' ); ?>
						</option>
						<option value="a-z" <?php if( $s_sort == 'a-z' ) echo 'selected'; ?>>
							<?php esc_html_e( 'A-Z', 'ova-sev' ); ?>
						</option>
						<option value="z-a" <?php if( $s_sort == 'z-a' ) echo 'selected'; ?>>
							<?php esc_html_e( 'Z-A', 'ova-sev' ); ?>
						</option>
						<option value="sort-order-desc" <?php if( $s_sort == 'sort-order-desc' ) echo 'selected'; ?>>
							<?php esc_html_e( 'Sort Order Desc', 'ova-sev' ); ?>
						</option>
						<option value="sort-order-asc" <?php if( $s_sort == 'sort-order-asc' ) echo 'selected'; ?>>
							<?php esc_html_e( 'Sort Order Asc', 'ova-sev' ); ?>
						</option>
						<option value="rand" <?php if( $s_sort == 'rand' ) echo 'selected'; ?>>
							<?php esc_html_e( 'Random', 'ova-sev' ); ?>
						</option>
					</select>
				</div>
				<?php endif; ?>
		</div>

		<div class="wrapper">
			<?php while ( $services->have_posts() ) : $services->the_post();
				ovasev_get_template( 'parts/item-service.php', $args_show );
			endwhile;?>
		</div>
	<?php else: ?>
		<p><?php esc_attr_e( 'Not found !', 'ova-sev' ); ?></p>
	<?php endif;wp_reset_postdata();
}

// query service ajax element
function ova_get_service_ajax( $cat_name, $list_sevs, $show_desc ) { 
	?>
	<div class="service-post-list-wrapper">
		<?php if( $cat_name ) { ?>
			<h3 class="service-category-name">
				<?php echo esc_html($cat_name);?>	
			</h3>
		<?php } ?>

		<?php if( !empty($list_sevs) ) { ?>
			<div class="service-post-list">
				<?php if ($list_sevs) : foreach ( $list_sevs as $sev ) :
					$id_sev 		= $sev->ID;
					$title_sev 		= $sev->post_title;
					$desc_sev       = $sev->post_excerpt;
					if($desc_sev == '') {
						$desc_sev   = $sev->post_content;
					}
				?>
					<a class="item-link" href="<?php echo get_the_permalink( $id_sev ); ?>">
						<div class="title-wrap">
							<h4 class="title">
								<?php echo esc_html( $title_sev ); ?>
							</h4>
							<i aria-hidden="true" class="flaticonnew- flaticon-new-right-arrows"></i>
						</div>
						<?php if( $show_desc == 'yes' ) { ?>
							<p class="desc">
								<?php echo esc_html( ova_sev_custom_text( $desc_sev, 12 ) ); ?>	
							</p>
						<?php } ?>
					</a>
				<?php endforeach; endif; ?>
			</div>
		<?php } else { ?>
			<p><?php esc_attr_e( 'Not found !', 'ova-sev' ); ?></p>
		<?php } ?>
	</div>
	<?php
}

function ova_sev_get_child_cate( $parent_id, $term_ids){
	if (! $parent_id) {
		return;
	}
	$args = array(
		'taxonomy' 		=> 'cat_sev',
		'orderby' 		=> 'name',
		'order'   		=> 'ASC',
		'hide_empty' 	=> false,
		'parent' 		=> $parent_id,
	);
	$id 				= get_the_ID();
	$term_id 			= get_queried_object_id();
	$child_categories 	= get_categories( $args );

	if ( $child_categories ) {
	?>

		<ul class="child-cate">
			<?php foreach ($child_categories as $child) {
				$active_class = $child->term_id == $term_id ? 'active' : '';
				if ( $id ) {
					$active_class = in_array( $child->term_id, $term_ids) ? 'active' : '';
				}
			?>
				<li class="item">
					<a href="<?php echo esc_url( get_term_link( $child ) ); ?>"
						class="item-link <?php echo esc_attr( $active_class ); ?>"
						data-slug="<?php echo esc_attr( $child->slug ); ?>"
						title="<?php echo esc_attr( $child->name ); ?>"
					>
						<span class="cate_name"><?php echo esc_html( $child->name ); ?></span>
						<?php if (get_term_children( $child->term_id, 'cat_sev' ) ): ?>
							<i class="fas fa-plus"></i>
						<?php endif; ?>
					</a>
					<?php ova_sev_get_child_cate( $child->term_id, $term_ids); ?>
				</li>
			<?php } ?>
		</ul>

		<?php
	}
}

// get list category service dropdown
add_filter( 'ovasev_cat_dropdown', 'ovasev_cat_dropdown');
function ovasev_cat_dropdown($selected){
	$args = array(
		'show_option_all'   => '' ,
		'show_option_none'   => esc_html__( 'All Categories', 'ova-sev' ),
		'post_type'         => 'ova_sev',
		'post_status'       => 'publish',
		'posts_per_page'    => '-1',
		'option_none_value' => 'all',
		'orderby'           => 'ID',
		'order'             => 'ASC',
		'show_count'        => 0,
		'hide_empty'        => 0,
		'child_of'          => 0,
		'exclude'           => '',
		'include'           => '',
		'echo'              => 1,
		'selected'          => $selected,
		'hierarchical'      => 1,
		'name'              => 'category',
		'id'                => 'ovasev_category',
		'depth'             => 0,
		'tab_index'         => 0,
		'taxonomy'          => 'cat_sev',
		'hide_if_empty'     => false,
		'value_field'       => 'slug',
		'class' 			=> 'ovasev_cat',
	);
	
	return wp_dropdown_categories($args);
}

function ova_sev_custom_text ($content = "",$limit = 15) {

    $content = explode(' ', $content, $limit);

    if (count($content)>=$limit) {
        array_pop($content);
        $content = implode(" ",$content).'...';
    } else {
        $content = implode(" ",$content);
    }

    $content = preg_replace('`[[^]]*]`','',$content);
    
    return strip_tags( $content );
}

// Get all id service
function ova_sev_get_all_id(){
   $all_ids = get_posts( array(
        'post_type'      => 'ova_sev',
        'posts_per_page' => -1,
        'post_status'    => 'publish',
        'fields'         => 'ids',
    ));

    return $all_ids;
}