<?php if ( !defined( 'ABSPATH' ) ) exit();
	$services = ova_sev_query($args);
?>

<div class="ova-sev-icon-box">
	<ul class="wrapper">
		<?php if ( $services->have_posts() ) : while ( $services->have_posts() ) : $services->the_post();
			$id   = get_the_ID();
			$icon = get_post_meta( $id, 'ova_sev_met_class_icon', true );
		?>
			<li class="item">
				<?php if($show_icon == 'yes' || $show_shape == 'yes' ) : ?>
					<div class="icon-wrapper">
						<?php if($icon && $show_icon == 'yes') : ?>
							<div class="icon">
								<i class="<?php echo esc_attr( $icon ); ?>" aria-hidden="true"></i>
							</div>
						<?php endif; ?>

						<?php if($show_shape == 'yes') : ?>
							<div class="icon-shape"></div>
						<?php endif; ?>
					</div>
				<?php endif; ?>

				<div class="info">
					<?php if($show_title == 'yes') : ?>
						<h3 class="title">
							<a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
								<?php the_title(); ?>
							</a>
						</h3>
					<?php endif; ?>

					<?php if($show_arrow == 'yes') : ?>
						<a href="<?php the_permalink(); ?>" aria-label="<?php esc_attr_e( 'Service Link','ova-sev' ); ?>"
							class="link" title="<?php the_title(); ?>"
						>
							<i class="fas fa-arrow-right" aria-hidden="true"></i>
						</a>
					<?php endif; ?>
				</div>
			</li>
		<?php endwhile; endif; wp_reset_postdata(); ?>
	</ul>
</div>