<?php if ( !defined( 'ABSPATH' ) ) exit();

	$image 			= $args['image'];
	$title 			= $args['title'];
	$services 		= ova_sev_query($args);
	$image_url 		= $image['url'] ? $image['url'] : \Elementor\Utils::get_placeholder_image_src();
	$image_alt 		= $title;
	$image_bg 		= $args['image_bg'];
	$image_bg_url 	= $image_bg['url'] ? $image_bg['url'] : \Elementor\Utils::get_placeholder_image_src();

	if ( $image && $image['id'] ) {
		$image_alt = get_post_meta( $image['id'], '_wp_attachment_image_alt', true ); 
		if ( ! $image_alt ) {
			$image_alt = get_the_title( $image['id'] );
		}
	}

?>

<div class="ova-sev-list-box-2" style="background-image: url('<?php echo esc_url( $image_bg_url ); ?>');">
	<div class="image">
		<img src="<?php echo esc_url( $image_url ); ?>" alt="<?php echo esc_attr( $image_alt ); ?>">
	</div>

	<div class="info">
		<div class="line" aria-hidden="true"></div>

		<?php if($title) { ?>
			<h3 class="heading">
				<?php echo esc_html( $title ); ?>
			</h3>
		<?php } ?>

		<?php if ( $services->have_posts() ) : ?>
			<div class="services">
				<ul class="wrapper">
					<?php while ( $services->have_posts() ) : $services->the_post(); ?>
						<li class="item">
							<a href="<?php the_permalink(); ?>" class="title" title="<?php the_title(); ?>">
								<?php if($show_icon == 'yes') { ?>
									<i class="fas fa-angle-double-right" aria-hidden="true"></i>
								<?php } ?>
								<?php the_title(); ?>
							</a>
						</li>
					<?php endwhile;?>
				</ul>
			</div>
		<?php endif;wp_reset_postdata(); ?>
	</div>
</div>