<?php if ( !defined( 'ABSPATH' ) ) exit();

	$template 		 = $args['template'];
	$template_layout = (isset($args['template_layout']) && ($template == 'template6'))  ? $args['template_layout'] : '';

	$show_icon    = isset($args['show_icon'])    ? $args['show_icon'] : 'yes';
	$show_title   = isset($args['show_title'])   ? $args['show_title'] : 'yes';
	$show_number  = isset($args['show_number'])  ? $args['show_number'] : 'yes';
	$show_line    = isset($args['show_line'])    ? $args['show_line'] : 'yes';
	$show_excerpt = isset($args['show_excerpt']) ? $args['show_excerpt'] : 'yes';
	$show_link_to = isset($args['show_link_to']) ? $args['show_link_to'] : 'yes';

	$deps  = ova_dep_get_department_elements($args);
	$count = 0;

?>


<div class="ova_list_dep <?php echo esc_attr( $template.' '.$template_layout.' '.$number_column ); ?>">

	<?php if($deps->have_posts() ) : while ( $deps->have_posts() ) : $deps->the_post();
		$count++; 
		$id = get_the_id();

		$class_icon = get_post_meta( $id, 'ova_dep_met_class_icon', true );
		$title 		= get_the_title();
		$excerpt 	= ova_dep_custom_text( get_the_excerpt(), 5 );
		$thumbnail  = wp_get_attachment_image_url( get_post_thumbnail_id( $id ), 'medium' );
		if ( $thumbnail == '') {
	    	$thumbnail   =  \Elementor\Utils::get_placeholder_image_src();
	    }
	?>

		<div class="items">

			<img class="follow-img" src="<?php echo esc_attr($thumbnail);?>" alt="<?php echo esc_attr($title);?>">

			<?php if( $show_number == 'yes' ) { ?>
				<?php if( $template === 'template1' || $template === 'template5' ) { ?>
					<span class="number">
						<?php echo sprintf('%02s', $count);?>
					</span>
				<?php } ?>
			<?php } ?>

			<?php if( ! empty( $class_icon ) && $show_icon == 'yes' ) { ?>
				<div class="icon">
					<i aria-hidden="true" class="<?php echo esc_attr( $class_icon ); ?>"></i>
				</div>
			<?php } ?>

			<?php if($template === 'template4') { ?>
			<div class="content-wrapper">
			<?php } ?>

				<?php if( ! empty( $title ) && $show_title == 'yes' ){ ?>
					<h2 class="title">
						<?php if( $show_link_to == 'yes' ){ ?>
						<a href="<?php echo get_the_permalink(); ?>">
						<?php } ?>
							<?php echo esc_html($title); ?>
						<?php if( $show_link_to == 'yes' ){ ?>
						</a>
						<?php } ?>
					</h2>
				<?php } ?>

				<?php if( ! empty( $excerpt ) && $template === 'template4' && $show_excerpt == 'yes' ){ ?>
					<p class="description">
						<?php printf($excerpt); ?>
					</p>
				<?php } ?>

			<?php if($template === 'template4') { ?>
			</div>
			<?php } ?>

			<?php if($template === 'template4') { ?>
				<a class="arrow-button" href="<?php echo get_the_permalink(); ?>" aria-label="<?php esc_attr_e('View Department','ova-dep');?>">
					<i aria-hidden="true" class="ovaicon ovaicon-next-4"></i>
				</a>
			<?php } ?>

			<?php if( $template === 'template3') {?>
				<span class="divider"></span>
			<?php } ?>

		</div>

	<?php endwhile; endif; wp_reset_postdata(); ?>
	
</div>