<?php if ( !defined( 'ABSPATH' ) ) exit();

	if ( isset( $args['id'] ) && $args['id'] ) {
		$id = $args['id'];
	} else {
		$id = get_the_id();
	}

	$class_icon = get_post_meta( $id, 'ova_dep_met_class_icon', true );
	$title 		= get_the_title();
	$excerpt 	= ova_dep_custom_text( get_the_excerpt(), 12 );
	$thumbnail  = wp_get_attachment_image_url( get_post_thumbnail_id( $id ), 'gimont_medium' );

	if ( $thumbnail == '') {
    	$thumbnail  = \Elementor\Utils::get_placeholder_image_src();
    }
   	
   	// show fields
   	$show_thumbnail = isset($args['show_thumbnail']) ? $args['show_thumbnail'] : 'yes';
    $show_icon      = isset($args['show_icon']) ? $args['show_icon'] : 'yes';
    $show_title     = isset($args['show_title']) ? $args['show_title'] : 'yes';
    $show_excerpt   = isset($args['show_excerpt']) ? $args['show_excerpt'] : 'yes';
    $show_readmore  = isset($args['show_readmore']) ? $args['show_readmore'] : 'yes';

?>

	<div class="ova-item-department">

		<?php if( $thumbnail && $show_thumbnail == 'yes' ) { ?>
			<div class="ova-media">
				<a href="<?php echo get_the_permalink(); ?>">
					<img src="<?php echo esc_attr( $thumbnail ) ; ?>" alt="<?php echo esc_attr( $title ); ?>">
				</a>
				<?php if($show_readmore == 'yes') : ?>
					<a class="readmore" href="<?php echo get_the_permalink(); ?>" >
						<span class="text-button">
							<?php echo esc_html__('Read more', 'ova-dep'); ?>
						</span>
						<i aria-hidden="true" class="gimonticon gimonticon-right"></i>
					</a>
				<?php endif; ?>
			</div>
		<?php } ?>

		<div class="ova-content">
			<?php if( $class_icon && $show_icon == 'yes' ){ ?>
				<div class="icon">
					<i class="<?php echo esc_attr( $class_icon ); ?>" aria-hidden="true"></i>
				</div>
			<?php } ?>

			<?php if( $show_title == 'yes' ){ ?>
				<h2 class="title">
					<a class="second_font" href="<?php echo get_the_permalink(); ?>">
						<?php echo esc_html($title); ?>
					</a>
				</h2>
			<?php } ?>

			<?php if( ! empty( $excerpt ) && $show_excerpt == 'yes' ){ ?>
				<p class="description">
					<?php printf($excerpt); ?>
				</p>
			<?php } ?>

		</div>

	</div>