<?php if ( !defined( 'ABSPATH' ) ) exit();

    if ( isset( $args['id'] ) && $args['id'] ) {
		$id = $args['id'];
	} else {
		$id = get_the_id();
	}

	$thumbnail  = get_the_post_thumbnail_url($id, 'thumbnail' );
	$category 	= get_the_terms($id, 'cat_career');

	$created_by	   = get_post_meta( $id, 'ova_career_met_created_by', true );
	$venue	   	   = get_post_meta( $id, 'ova_career_met_venue', true );
	$salary  	   = get_post_meta( $id, 'ova_career_met_salary', true );
	$working_from  = get_post_meta( $id, 'ova_career_met_working_from', true );
	
	// show fields
	$show_heart     	= isset( $args['show_heart'] ) ? $args['show_heart'] : 'yes';
	$show_thumbnail 	= isset( $args['show_thumbnail'] ) ? $args['show_thumbnail'] : 'yes';
	$show_title 		= isset( $args['show_title'] ) ? $args['show_title'] : 'yes';
	$show_created_by    = isset( $args['show_created_by'] ) ? $args['show_created_by'] : 'yes';
	$show_category      = isset( $args['show_category'] ) ? $args['show_category'] : 'yes';
	$show_working_from  = isset( $args['show_working_from'] ) ? $args['show_working_from'] : 'yes';
	$show_venue  		= isset( $args['show_venue'] ) ? $args['show_venue'] : 'yes';
	$show_salary  		= isset( $args['show_salary'] ) ? $args['show_salary'] : 'yes';
	$show_link_to   	= isset( $args['show_link_to'] ) ? $args['show_link_to'] : 'yes';

?>

    <div class="item-career">

    	<?php if( $show_heart == 'yes' ) : ?>
		    <div class="icon-heart">
	    		<i aria-hidden="true" class="fas fa-heart"></i>
	    	</div>
	    <?php endif;?>

    	<div class="top-info">
            
            <?php if( $show_thumbnail == 'yes' && !empty($thumbnail) ) : ?>
	            <img src="<?php echo esc_url( $thumbnail ); ?>" alt="<?php the_title(); ?>" class="career-thumbnail">
	        <?php endif;?>

            <div class="right">
            	<?php if ($show_title == 'yes'): ?>
            		<?php if( $show_link_to == 'yes' ) : ?>
	            	<a href="<?php the_permalink();?>"> 
	            	<?php endif; ?>
		            	<h1 class="career-title">
						    <?php the_title();?>
					    </h1>
					<?php if( $show_link_to == 'yes' ) : ?>
				    </a>
				    <?php endif; ?>
				<?php endif;?>

			    <div class="by-and-categories">
			    	<?php if( $show_created_by == 'yes' && !empty($created_by) ) : ?>
				    	<div class="by">
				    		<span class="text">
				    			<?php esc_html_e( 'By', 'ova-career'); ?> 
				    		</span>
				    		<span class="name">
				    			<?php echo esc_html($created_by); ?> 
				    		</span>
				    	</div>
				    <?php endif; ?>
			    	
			    	<?php if( $show_category == 'yes' ) : ?>
				    	<div class="categories">
			    			<span class="text">
				    			<?php esc_html_e( 'in', 'ova-career'); ?> 
				    		</span>
				    		<span class="value">
				    			<?php $category_first_link = get_term_link($category[0]->term_id);
							        if ( $category_first_link ) {
							        	echo '<a href="'.esc_url( $category_first_link ).'" title="'.esc_attr($category[0]->name).'">'.$category[0]->name.'</a>';
							        }
								?>
				    		</span>
				    	</div>
				    <?php endif; ?>
			    </div>

			    <?php if ($show_working_from == 'yes' || $show_venue == 'yes' || $show_salary == 'yes'): ?>
				    <div class="tag-wrapper">
				    	<?php if( !empty($working_from) && $show_working_from == 'yes' ) : ?>
					    	<span class="tag from">
					    		<?php echo esc_html($working_from); ?>
					    	</span>
				    	<?php endif; ?>

				    	<?php if( !empty($venue) && $show_venue == 'yes' ) : ?>
					    	<span class="tag location">
					    		<i aria-hidden="true" class="ovaicon ovaicon-placeholder"></i>
					    		<?php echo esc_html($venue); ?>
					    	</span>
				    	<?php endif; ?>

				    	<?php if( !empty($salary) && $show_salary == 'yes' ) : ?>
					    	<span class="tag salary">
					    		<i aria-hidden="true" class="flaticon-new-dollar"></i>
					    		<?php echo esc_html($salary); ?>
					    	</span>
					    <?php endif; ?>
				    </div>
				<?php endif; ?>
            </div>
		   
    	</div>

	</div>