<?php
namespace ova_sev_elementor\Widgets;

use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class ova_sev_category extends Widget_Base {

	public function get_name() {
		return 'ova_sev_category';
	}

	public function get_title() {
		return esc_html__( 'Service Category', 'ova-sev' );
	}

	public function get_icon() {
		return 'eicon-bullet-list';
	}

	public function get_categories() {
		return [ 'ovatheme_service' ];
	}

	public function get_script_depends() {
		wp_enqueue_script('ova-sev-category', OVASEV_PLUGIN_URI.'assets/js/elementor/sev-category.js', array('jquery'), false, true);
		return [ '' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'ova-sev-category', OVASEV_PLUGIN_URI.'/assets/css/elementor/sev-category.css', array(), null);
		return [];
	}

	protected function register_controls() {

		/* Content */
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'ova-sev' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

			$this->add_control(
				'sev_title',
				[
					'label' => esc_html__( 'Title', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__( 'All Categories', 'ova-sev' ),
					'label_block' => true,
				]
			);

			$this->add_control(
				'category_not_in',
				[
					'label'   		=> esc_html__( 'Category Not In', 'ova-sev' ),
					'type'    		=> \Elementor\Controls_Manager::TEXT,
					'description' 	=> esc_html__( 'Enter the service category IDs. IDs are separated by "|". Ex: 1|2|3.', 'ova-sev' ),
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name' => 'cate_border',
					'selector' => '{{WRAPPER}} .ova-sev-category .service-cat-list',
				]
			);
			
		$this->end_controls_section();

		/* Title */
		$this->start_controls_section(
				'title_style_section',
				[
					'label' => esc_html__( 'Title', 'ova-sev' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'title_typography',
					'selector' => '{{WRAPPER}} .ova-sev-category .title',
				]
			);

			$this->add_control(
				'title_color',
				[
					'label' => esc_html__( 'Color', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-sev-category .title' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'title_background',
				[
					'label' => esc_html__( 'Background', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-sev-category .title' => 'background: {{VALUE}}',
						'{{WRAPPER}} .ova-sev-category .title:after' => 'border-top-color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/*Category*/
		$this->start_controls_section(
				'category_style_section',
				[
					'label' => esc_html__( 'Category', 'ova-sev' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'cate_typography',
					'selector' => '{{WRAPPER}} .ova-sev-category .service-cat-list .cate_name',
				]
			);

			$this->start_controls_tabs(
				'cate_style_tabs'
				);

				$this->start_controls_tab(
						'cate_style_normal_tab',
						[
							'label' => esc_html__( 'Normal', 'ova-sev' ),
						]
					);

					$this->add_control(
						'cate_color',
						[
							'label' => esc_html__( 'Color', 'ova-sev' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-sev-category .service-cat-list .cate_name' => 'color: {{VALUE}}',
								'{{WRAPPER}} .ova-sev-category .service-cat-list .item-link i' => 'color: {{VALUE}}',
							],
						]
					);

					$this->add_control(
						'cate_background',
						[
							'label' => esc_html__( 'Background', 'ova-sev' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-sev-category .service-cat-list .item-link' => 'background: {{VALUE}}',
							],
						]
					);

				$this->end_controls_tab();

				$this->start_controls_tab(
					'cate_style_hover_tab',
						[
							'label' => esc_html__( 'Hover', 'ova-sev' ),
						]
					);

					$this->add_control(
						'cate_hover_color',
						[
							'label' => esc_html__( 'Color', 'ova-sev' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-sev-category .service-cat-list .cate_name:hover' => 'color: {{VALUE}}',
								'{{WRAPPER}} .ova-sev-category .service-cat-list .item-link i:hover' => 'color: {{VALUE}}',
							],
						]
					);

					$this->add_control(
						'cate_hover_background',
						[
							'label' => esc_html__( 'Background', 'ova-sev' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-sev-category .service-cat-list .item-link:hover' => 'background: {{VALUE}}',
								'{{WRAPPER}} .ova-sev-category .service-cat-list .item-link.active' => 'background: {{VALUE}}',
							],
						]
					);

				$this->end_controls_tab();

			$this->end_controls_tabs();

		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();
		$template = apply_filters( 'el_elementor_ova_sev_category', 'elementor/ova_sev_category.php' );

		ob_start();
		ovasev_get_template( $template, $settings );
		echo ob_get_clean();
	}
}
