<?php if ( !defined( 'ABSPATH' ) ) exit();

	if ( isset( $args['id'] ) && $args['id'] ) {
		$id = $args['id'];
	} else {
		$id = get_the_id();
	}

	$image_src 	= \Elementor\Utils::get_placeholder_image_src();
	$image_alt 	= get_the_title();
	$class_icon = get_post_meta( $id, 'ova_sev_met_class_icon', true );

	if ( has_post_thumbnail( $id ) ) {
		$image_id 	= get_post_thumbnail_id( $id );
		$image_src 	= get_the_post_thumbnail_url( $id, 'ova_sev_thumbnail' );
		if ( get_post_meta( $image_id, '_wp_attachment_image_alt', true) ) {
			$image_alt = get_post_meta( $image_id, '_wp_attachment_image_alt', true);
		}
	}

	// show fields
	$show_icon    		= isset($args['show_icon']) ? $args['show_icon'] : 'yes';
	$show_title   		= isset($args['show_title']) ? $args['show_title'] : 'yes';
	$show_link_of_title = isset($args['show_link_of_title']) ? $args['show_link_of_title'] : 'yes';
	$show_desc    		= isset($args['show_desc']) ? $args['show_desc'] : 'yes';
	$show_button	    = isset($args['show_button']) ? $args['show_button'] : 'yes';

?>

	<div class="item ova-item-service">
		<div class="image">
			<img src="<?php echo esc_url( $image_src ); ?>" alt="<?php echo esc_attr( $image_alt ); ?>">
		</div>

		<div class="content">
			<div class="content-wrap">
				<?php if($show_icon == 'yes' && !empty($class_icon)) : ?>
					<div class="icon">
						<i class="<?php echo esc_attr( $class_icon ); ?>" aria-hidden="true"></i>
					</div>
				<?php endif; ?>

				<div class="info">
					<?php if($show_title == 'yes') : ?>
						<?php if($show_link_of_title == 'yes') : ?>
						<a href="<?php the_permalink(); ?>">
						<?php endif; ?>
							<h3 class="title">
								<?php the_title(); ?>
							</h3>
						<?php if($show_link_of_title == 'yes') : ?>
						</a>
						<?php endif; ?>
					<?php endif; ?>
				</div>
			</div>
		</div>

		<div class="content content-hover">
			<div class="content-wrap">
				<?php if($show_icon == 'yes' && !empty($class_icon)) : ?>
					<div class="icon">
						<i class="<?php echo esc_attr( $class_icon ); ?>" aria-hidden="true"></i>
					</div>
				<?php endif; ?>

				<div class="info">
					<?php if($show_title == 'yes') : ?>
						<?php if($show_link_of_title == 'yes') : ?>
						<a href="<?php the_permalink(); ?>">
						<?php endif; ?>
							<h3 class="title">
								<?php the_title(); ?>
							</h3>
						<?php if($show_link_of_title == 'yes') : ?>
						</a>
						<?php endif; ?>
					<?php endif; ?>

					<div class="info-hidden">
						<?php if($show_desc == 'yes') : ?>
							<p class="desc">
								<?php echo esc_html( ova_sev_custom_text( get_the_excerpt(), 12 ) ); ?>	
							</p>
						<?php endif; ?>

						<?php if($show_button == 'yes') : ?>
							<a href="<?php the_permalink(); ?>" title="<?php esc_attr_e( 'View Service', 'ova-sev' ); ?>" class="link">
								<span class="text">
									<?php esc_html_e( 'View Service', 'ova-sev' ); ?>
								</span>
								<i class="gimonticon gimonticon-right" aria-hidden="true"></i>
							</a>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>

	</div>