<?php if ( !defined( 'ABSPATH' ) ) exit();
   
    if ( isset( $args['id'] ) && $args['id'] ) {
		$id = $args['id'];
	} else {
		$id = get_the_id();
	}
	
	$image_id 		= get_post_thumbnail_id();
	$image_alt 		= get_the_title();
	$image_src 		= '';

	if ( $image_id ) {
		if ( get_post_meta( $image_id, '_wp_attachment_image_alt', true ) ) {
			$image_alt = get_post_meta( $image_id, '_wp_attachment_image_alt', true );
		} else {
			$image_alt = get_the_title( $image_id );
		}
		$image_src 		= isset(wp_get_attachment_image_src( $image_id, 'large' )[0]) ? wp_get_attachment_image_src( $image_id, 'large' )[0] : '';
	}

	if( $image_src == '' ) {
		$image_src  = \Elementor\Utils::get_placeholder_image_src();
	}

	$job = get_post_meta( $id, 'ova_team_met_job', true );
	$list_social = get_post_meta( $id, 'ova_team_met_group_icon', true );

	// show fields
	$show_image 	= isset($args['show_image']) ? $args['show_image'] : 'yes';
	$show_name 		= isset($args['show_name']) ? $args['show_name'] : 'yes';
	$show_job  		= isset($args['show_job']) ? $args['show_job'] : 'yes';
	$show_social  	= isset($args['show_social']) ? $args['show_social'] : 'yes';
	$show_link_to  	= isset($args['show_link_to']) ? $args['show_link_to'] : 'yes';

?>

	<div class="items elementor-items">
		<div class="ova-media">
			<?php if( $show_image == 'yes' ) { ?>
				<img src="<?php echo esc_url( $image_src ); ?>" alt="<?php echo esc_attr( $image_alt ); ?>">
			<?php } ?>

			<?php if ( $list_social && $show_social == 'yes' ) : ?>
				<div class="ova-social-wrap">
					<div class="ova-social-inner">
						<ul class="ova-social">
							<?php foreach( $list_social as $social ){
								$class_icon = isset( $social['ova_team_met_class_icon_social'] ) ? $social['ova_team_met_class_icon_social'] : '';
								$link_social = isset( $social['ova_team_met_link_social'] ) ? $social['ova_team_met_link_social'] : '';
							?>
								<li class="icon">
									<a href="<?php echo esc_url( $link_social ); ?>" target="_blank" 
										aria-label="<?php esc_attr_e( 'Share social team link', 'ova-team' ); ?>"
									>
										<i class="<?php echo esc_attr( $class_icon ) ?>" aria-hidden="true"></i>
									</a>
								</li>
							<?php } ?>
						</ul>
					</div>
				</div>
			<?php endif; ?>
		</div>

		<div class="ova-info-content">
			<?php if( $show_name == 'yes' ) { ?>
				<h3 class="name">
					<?php if( $show_link_to == 'yes' ) { ?>
					<a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
					<?php } ?>
						<?php the_title(); ?>
					<?php if( $show_link_to == 'yes' ) { ?>
					</a>
					<?php } ?>
				</h3>
			<?php } ?>

			<?php if( ! empty( $job ) && $show_job == 'yes' ) { ?>
				<p class="job">
					<?php echo esc_html( $job ) ?>
				</p>
			<?php } ?>
		</div>
	</div>