jQuery(document).ready(function($) {

    $('.ova_team_single .progress-bar .percent').each(function( index ) {
        var percent = $(this).attr('data-percent');
        $(this).animate({width: `${percent}%`}, 1000, function(){
            $(this).find('.num').show();
        });
    });

    $('.ova_archive_team .list-cat-team .cate_name').on("click",function(e){
        e.preventDefault();
        var id          = $(this).attr("data-id");
        var items       = $(".ova_archive_team .list-cat-team .item");
        var item        = $(this).parent();

        var loader      = $(".ova_archive_team .ova-team-loader .loader");
        var teamContent = $(".ova_archive_team .content_inner");

        var template   = teamContent.attr('data-template');
        var args_show  = JSON.parse( teamContent.attr('data-args_show') );

        items.removeClass("active");
        item.addClass("active");
        loader.addClass("is-active");
        teamContent.addClass("overlay");

        $.ajax({
            type: "post",
            dataType: "html",
            url: ova_team_ajax_object.ajax_url,
            data: {
                action: 'ova_team_cate_show_list',
                id: id,
                template: template,
                args_show: args_show
            },
            success: function(response){
                loader.removeClass("is-active");
                teamContent.removeClass("overlay");
                teamContent.html(response);
            },
            error: function(err){
                console.log(err);
            }
        });
    });

    /* Team Pagination */
    $(document).on('click', ".ova_team_pagination_ajax .page-numbers", function (e) {    

        e.preventDefault();
        var dataArgs    = $(document).find(".ova_team_pagination_ajax").attr("data-args");
        var args        = JSON.parse( dataArgs );
        var offset      = parseInt( $(this).attr("data-offset") );
        var page        = parseInt( $(this).attr("data-page") );

        var teamContent = $(".ova_archive_team .content_inner");
        var loader      = $(".ova-team-loader .loader");

        var template    = teamContent.attr('data-template');
        var args_show   = JSON.parse( teamContent.attr('data-args_show') );

        if (page) {
            loader.addClass("is-active");
            teamContent.addClass("overlay");
            $('html, body').animate({
                scrollTop: $(".ova_archive_team_page").offset().top
            });
            $.ajax({
                type: "post",
                dataType: "html",
                url: ova_team_ajax_object.ajax_url,
                data: {
                    action: 'ova_team_pagination_ajax',
                    args: args,
                    offset: offset,
                    page: page,
                    template: template,
                    args_show: args_show
                },
                success: function(response){
                    loader.removeClass("is-active");
                    teamContent.removeClass("overlay");
                    teamContent.html(response);
                }
            });
        }
    });

});