<?php

if ( !defined( 'ABSPATH' ) ) {
	exit;
}

class OVATEAM_Ajax {

	public function __construct() {
		add_action( 'wp_ajax_ova_team_pagination_ajax', array( $this, 'ova_team_pagination_ajax' ) );
		add_action( 'wp_ajax_nopriv_ova_team_pagination_ajax', array( $this, 'ova_team_pagination_ajax' ) );

		add_action('wp_ajax_ova_team_cate_show_list', array( $this, 'ova_team_cate_show_list' ) );
		add_action('wp_ajax_nopriv_ova_team_cate_show_list', array( $this, 'ova_team_cate_show_list' ) );
	}

	public function ova_team_pagination_ajax() {
		$args 			= $_POST['args'];
		$offset			= $_POST['offset'];
		$curent_page 	= intval( $_POST['page'] );
		$args['offset'] = intval( $offset );

		$template       = isset($_POST['template'])  ? $_POST['template'] : 'grid_default';
		$args_show      = isset($_POST['args_show']) ? $_POST['args_show'] : [];

		$teams 				= ova_query_team_ajax( $args );
		$total_pages 		= $teams->max_num_pages;
		$posts_per_page 	= intval( $args['posts_per_page'] );

		ob_start();
		ova_team_show_list( $teams, $template, $args_show  );
		ova_team_pagination_ajax($total_pages,$curent_page,$posts_per_page,$args);
		echo ob_get_clean();
		wp_die();
	}

	public function ova_team_cate_show_list(){
		$id = intval( $_POST['id'] );

		$template       = isset($_POST['template'])  ? $_POST['template'] : 'grid_default';
		$args_show      = isset($_POST['args_show']) ? $_POST['args_show'] : [];

		$posts_per_page = get_theme_mod( 'ova_team_total_record', 6 );
		$orderby 		= get_theme_mod( 'ova_team_orderby', 'ID' );
		$order 			= get_theme_mod( 'ova_team_order', 'DESC' );

		$args = array(
			'posts_per_page' 	=> $posts_per_page ,
			'orderby' 			=> $orderby,
			'order' 			=> $order,
			'cate'				=> $id,
		);

		$teams 			= ova_query_team_ajax( $args );
		$total_pages 	= $teams->max_num_pages;
		$curent_page 	= 1;
		ob_start();
		ova_team_show_list( $teams, $template, $args_show );
		ova_team_pagination_ajax($total_pages,$curent_page,$posts_per_page,$args);
		echo ob_get_clean();
		wp_die();
	}
}

new OVATEAM_Ajax();