<?php if ( !defined( 'ABSPATH' ) ) exit();

get_header();

	global $wp_query;

	$number_column = get_theme_mod( 'ova_team_layout', 'three_column' );

	$term_id = get_queried_object_id();

	$class_active_all = $term_id == 0 ? 'active' : '';

	$cate_args = array(
		'taxonomy' 	=> 'cat_team',
		'orderby' 	=> 'name',
		'order'   	=> 'ASC',
		'hide_empty' => false,
	);

	$categories = get_categories($cate_args);

	$template 		= get_theme_mod( 'ova_team_template', 'grid_default' );
	$posts_per_page = get_theme_mod( 'ova_team_total_record', 6 );
	$order_by 		= get_theme_mod( 'ova_team_orderby', 'ID' );
	$order 			= get_theme_mod( 'ova_team_order', 'DESC' );

	// show fields
	$show_filter  = get_theme_mod( 'archive_team_show_filter', 'yes' );
	$show_image   = get_theme_mod( 'archive_team_show_image', 'yes' );
	$show_name    = get_theme_mod( 'archive_team_show_name', 'yes' );
	$show_job     = get_theme_mod( 'archive_team_show_job', 'yes' );
	$show_social  = get_theme_mod( 'archive_team_show_social', 'yes' );
	$show_link_to = get_theme_mod( 'archive_team_show_link_to', 'yes' );

	$args = array(
		'orderby' 			=> $order_by,
		'order' 			=> $order,
		'posts_per_page' 	=> $posts_per_page,
		'cate' 				=> $term_id,
	);

	$args_show = array(
		'show_image'        => $show_image,
		'show_name'         => $show_name,
		'show_job'          => $show_job,
		'show_social'       => $show_social,
		'show_link_to'      => $show_link_to,
	);

	// class archive
	if ( $template == "grid_modern" || $template == "grid_modern_2"  ) {
		$class_archive = 'archive_team modern';

		if($template == "grid_modern_2") {
			$class_archive = 'archive_team modern modern_type2';
		}

	} elseif( $template == "grid2_template_1" || $template == "grid2_template_2" ) {
		$class_archive = 'archive_team_2';

		if($template == "grid2_template_2") {
			$class_archive = 'archive_team_2 template_2';
		}

	} elseif( $template == "grid3_template_1" || $template == "grid3_template_2" ) {
		$class_archive = 'archive_team_3';

		if($template == "grid3_template_2") {
			$class_archive = 'archive_team_3 template_2';
		}

	} else {
		$class_archive = 'archive_team grid_default';
	}

?>

<div class="row_site">
	<div class="container_site">

		<div class="ova_archive_team_page ova_archive_team <?php echo esc_attr( $class_archive ); ?> <?php echo esc_attr( $number_column ); ?>">

			<?php if($show_filter == 'yes') : ?>
				<ul class="list-cat-team">
					<li class="item <?php echo esc_attr( $class_active_all ); ?>">
						<a href="<?php echo esc_url( get_post_type_archive_link( 'team' ) ); ?>"
							data-id="0" class="cate_name"
						>
							<?php esc_html_e( 'All', 'ova-team' ); ?>
						</a>
					</li>
					<?php if ( $categories ): foreach ($categories as $cate):
						$class_active = $term_id == $cate->term_id ? 'active' : ''; 
					?>
						<li class="item <?php echo esc_attr( $class_active ); ?>">
							<a href="<?php echo esc_url( get_term_link( $cate ) ); ?>"
								data-id="<?php echo esc_attr( $cate->term_id ); ?>"
								class="cate_name" title="<?php echo esc_attr( $cate->name ); ?>"
							>
								<?php echo esc_html( $cate->name ); ?>
							</a>
						</li>
					<?php endforeach; endif; ?>
				</ul>
			<?php endif; ?>

			<div class="ova-team-loader">
				<div class="loader"></div>
			</div>

			<div class="content_inner" data-template="<?php echo esc_attr( $template );?>"
				data-args_show="<?php echo esc_attr( json_encode($args_show) );?>"
			>
				<div class="content <?php if( $show_image != 'yes' ) echo 'no-image'; ?>">
					<?php if( have_posts() ) : while ( have_posts() ) : the_post();
						if ( $template == "grid_modern" || $template == "grid_modern_2"  ) {
							ovateam_get_template( 'parts/item-team-modern.php', $args_show );

						} elseif( $template == "grid2_template_1" || $template == "grid2_template_2" ) {
							ovateam_get_template( 'parts/item-team-2.php', $args_show );

						} elseif( $template == "grid3_template_1" || $template == "grid3_template_2" ) {
							ovateam_get_template( 'parts/item-team-3.php', $args_show );

						} else {
							ovateam_get_template( 'parts/item-team.php', $args_show );
						}
					endwhile; endif; wp_reset_postdata(); ?>
				</div>
				<?php
					$total_pages = $wp_query->max_num_pages;
					$curent_page = 1;
					ova_team_pagination_ajax($total_pages,$curent_page,$posts_per_page,$args);
				?>
			</div>

		</div>

	</div>
</div>

<?php 
get_footer();