<?php
namespace ova_ovaev_elementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class ova_events_slide extends Widget_Base {


	public function get_name() {		
		return 'ova_events_slide';
	}

	public function get_title() {
		return esc_html__( 'Events Slide', 'ovaev' );
	}

	public function get_icon() {
		return 'eicon-slider-album';
	}

	public function get_categories() {
		return [ 'ovatheme_event' ];
	}

	public function get_script_depends() {
		wp_enqueue_script( 'ovaev-events-slide', OVAEV_PLUGIN_URI.'assets/js/elementor/events-slide.js',  [ 'jquery' ], false, true );
		return [ '' ];
	}


	protected function register_controls() {

	   	$args = array(
           'taxonomy' => 'event_category',
           'orderby' => 'name',
           'order'   => 'ASC'
       	);
	
		$categories = get_categories($args);
		$category_all = array( 'all' => esc_html__( 'All categories', 'ovaev' ) );
		$category_data = array();
		if ($categories) {
			foreach ( $categories as $cate ) {
				$category_data[$cate->slug] = $cate->cat_name;
			}
		} else {
			$category_data["No content Category found"] = 0;
		}

		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Content', 'ovaev' ),
			]
		);

			$this->add_control(
				'category',
				[
					'label'   => esc_html__( 'Category', 'ovaev' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'all',
					'options' => array_merge( $category_all, $category_data )
				]
			);

			$this->add_control(
				'layout',
				[
					'label'   => esc_html__('Layout', 'ovaev'),
					'type'    => Controls_Manager::SELECT,
					'options' => [
						'1' => esc_html__('Layout 1','ovaev'),
						'2' => esc_html__('Layout 2','ovaev'),
						'3' => esc_html__('Layout 3','ovaev'),
						'4' => esc_html__('Layout 4','ovaev'),
						'5' => esc_html__('Layout 5','ovaev'),
						'6' => esc_html__('Layout 6','ovaev'),
						'7' => esc_html__('Layout 7','ovaev'),
					],
					'default' => '1',
				]
			);


			$this->add_control(
				'total_count',
				[
					'label'   => esc_html__( 'Post Total', 'ovaev' ),
					'type'    => Controls_Manager::NUMBER,
					'min'     => 1,
					'default' => 8,
				]
			);

			$this->add_control(
				'time_event',
				[
					'label'   => esc_html__('Choose time', 'ovaev'),
					'type'    => Controls_Manager::SELECT,
					'options' => [
						''     	   => esc_html__('All','ovaev'),
						'current'  => esc_html__('Current','ovaev'),
						'upcoming' => esc_html__('Upcoming','ovaev'),
						'past'     => esc_html__('Past','ovaev'),
					],
					'default'   => '',
				]
			);


			$this->add_control(
				'column',
				[
					'label' => esc_html__('Column','ovaev'),
					'type' => Controls_Manager::SELECT,
					'default' => 'two_column',
					'options' => [
						'two_column' => esc_html__('Two Columns', 'ovaev'),
						'three_column' => esc_html__('Three Columns', 'ovaev'),
 					],
 					'condition' => [
 						'version' => 'version_2'
 					],
				]
			);

			$this->add_control(
				'order_by',
				[
					'label'   => esc_html__( 'Order By', 'ovaev' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'ID',
					'options' => [
						'ID' => esc_html__( 'ID', 'ovaev' ),			
						'title' => esc_html__( 'Title', 'ovaev' ),
						'event_custom_sort' => esc_html__( 'Custom Sort', 'ovaev' ),
						'ovaev_start_date_time'  => esc_html__( 'Start Date', 'ovaev' ),			
					],
				]
			);

			$this->add_control(
				'order',
				[
					'label'   => esc_html__( 'Order', 'ovaev' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'DESC',
					'options' => [
						'DESC' => esc_html__( 'Descending', 'ovaev' ),
						'ASC'  => esc_html__( 'Ascending', 'ovaev' ),
					],

				]
			);

			$this->add_control(
				'exclude_cat',
				[
					'label' => esc_html__( 'Excluded Categories', 'ovaev' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'description' => 'ID category, example: 5, 7',
				]
			);

			$this->add_control(
				'show_thumbnail',
				[
					'label'        => esc_html__( 'Show Thumbnail', 'ovaev' ),
					'type'         => Controls_Manager::SWITCHER,
					'return_value' => 'yes',
					'default'      => 'yes',
					'separator' => 'before',
				]
			);

			$this->add_control(
				'show_date',
				[
					'label'        => esc_html__( 'Show Date', 'ovaev' ),
					'type'         => Controls_Manager::SWITCHER,
					'return_value' => 'yes',
					'default'      => 'yes',
					'condition'    => [
						'layout!' => '7'
					]
				]
			);

			$this->add_control(
				'show_hour',
				[
					'label'        => esc_html__( 'Show Hour', 'ovaev' ),
					'type'         => Controls_Manager::SWITCHER,
					'return_value' => 'yes',
					'default'      => 'yes',
					'condition'    => [
						'layout!' => '6'
					]
				]
			);

			$this->add_control(
				'show_location',
				[
					'label'        => esc_html__( 'Show Location', 'ovaev' ),
					'type'         => Controls_Manager::SWITCHER,
					'return_value' => 'yes',
					'default'      => 'yes',
				]
			);

			$this->add_control(
				'show_event_title',
				[
					'label'        => esc_html__( 'Show Title', 'ovaev' ),
					'type'         => Controls_Manager::SWITCHER,
					'return_value' => 'yes',
					'default'      => 'yes',
				]
			);

			$this->add_control(
				'show_short_desc',
				[
					'label'        => esc_html__( 'Show Excerpt', 'ovaev' ),
					'type'         => Controls_Manager::SWITCHER,
					'return_value' => 'yes',
					'default'      => 'yes',
					'condition'    => [
						'layout' => '5',
					]
				]
			);

			$this->add_control(
				'show_link_to',
				[
					'label'        => esc_html__( 'Show Link to Detail', 'ovaev' ),
					'type'         => Controls_Manager::SWITCHER,
					'return_value' => 'yes',
					'default'      => 'yes',
				]
			);
			
		$this->end_controls_section();
		

		$this->start_controls_section(
			'section_additional_options',
			[
				'label' => esc_html__( 'Additional Options', 'ovaev' ),
			]
		);


		/***************************  VERSION 1 ***********************/
			$this->add_control(
				'margin_items',
				[
					'label'   => esc_html__( 'Margin Right Items', 'ovaev' ),
					'type'    => Controls_Manager::NUMBER,
					'default' => 30,
				]
				
			);

			$this->add_control(
				'item_number',
				[
					'label'       => esc_html__( 'Item Number', 'ovaev' ),
					'type'        => Controls_Manager::NUMBER,
					'description' => esc_html__( 'Number Item', 'ovaev' ),
					'default'     => 3,
				]
			);

	

			$this->add_control(
				'slides_to_scroll',
				[
					'label'       => esc_html__( 'Slides to Scroll', 'ovaev' ),
					'type'        => Controls_Manager::NUMBER,
					'description' => esc_html__( 'Set how many slides are scrolled per swipe.', 'ovaev' ),
					'default'     => 1,
				]
			);

			$this->add_control(
				'pause_on_hover',
				[
					'label'   => esc_html__( 'Pause on Hover', 'ovaev' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'ovaev' ),
						'no'  => esc_html__( 'No', 'ovaev' ),
					],
					'frontend_available' => true,
				]
			);


			$this->add_control(
				'infinite',
				[
					'label'   => esc_html__( 'Infinite Loop', 'ovaev' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'ovaev' ),
						'no'  => esc_html__( 'No', 'ovaev' ),
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'autoplay',
				[
					'label'   => esc_html__( 'Autoplay', 'ovaev' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'ovaev' ),
						'no'  => esc_html__( 'No', 'ovaev' ),
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'autoplay_speed',
				[
					'label'     => esc_html__( 'Autoplay Speed', 'ovaev' ),
					'type'      => Controls_Manager::NUMBER,
					'default'   => 3000,
					'step'      => 500,
					'condition' => [
						'autoplay' => 'yes',
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'smartspeed',
				[
					'label'   => esc_html__( 'Smart Speed', 'ovaev' ),
					'type'    => Controls_Manager::NUMBER,
					'default' => 500,
				]
			);

			$this->add_control(
				'dot_control',
				[
					'label'   => esc_html__( 'Show Dots', 'ovaev' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'no',
					'options' => [
						'yes' => esc_html__( 'Yes', 'ovaev' ),
						'no'  => esc_html__( 'No', 'ovaev' ),
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'nav_control',
				[
					'label'   => esc_html__( 'Show Nav', 'ovaev' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'ovaev' ),
						'no'  => esc_html__( 'No', 'ovaev' ),
					],
					'frontend_available' => true,
				]
			);

			

		$this->end_controls_section();

	}

	protected function render() {

		$settings = $this->get_settings();

		$template = apply_filters( 'elementor_ovaev_slide', 'elements/ovaev_events_slide.php' );

		ob_start();
		ovaev_get_template( $template, $settings );
		echo ob_get_clean();

	}
}
