(function($){
	"use strict";
	
	// For View Map in destination detail
    function initMap( $el ) {

        // Find marker elements within map.
        var $markers = $el.find('.marker');

        // Create gerenic map.
        var mapArgs = {
            zoom        : $el.data('zoom') || 16,
            mapTypeId   : google.maps.MapTypeId.ROADMAP
        };
        var map = new google.maps.Map( $el[0], mapArgs );

        // Add markers.
        map.markers = [];
        $markers.each(function(){
            initMarker( $(this), map );
        });

        // Center map based on markers.
        centerMap( map );

        // Return map instance.
        return map;
    }

    function initMarker( $marker, map ) {

        // Get position from marker.
        var lat = $marker.data('lat');
        var lng = $marker.data('lng');
        var latLng = {
            lat: parseFloat( lat ),
            lng: parseFloat( lng )
        };

        // Create marker instance.
        var marker = new google.maps.Marker({
            position : latLng,
            map: map
        });

        // Append to reference for later use.
        map.markers.push( marker );

        // If marker contains HTML, add it to an infoWindow.
        if( $marker.html() ){

            // Create info window.
            var infowindow = new google.maps.InfoWindow({
                content: $marker.html()
            });

            // Show info window when marker is clicked.
            google.maps.event.addListener(marker, 'click', function() {
                infowindow.open( map, marker );
            });
        }
    }

    function centerMap( map ) {

        // Create map boundaries from all map markers.
        var bounds = new google.maps.LatLngBounds();
        map.markers.forEach(function( marker ){
            bounds.extend({
                lat: marker.position.lat(),
                lng: marker.position.lng()
            });
        });

        // Case: Single marker.
        if( map.markers.length == 1 ){
            map.setCenter( bounds.getCenter() );

        // Case: Multiple markers.
        } else{
            map.fitBounds( bounds );
        }
    }

	$(document).ready(function () {

		// Single Render Map
        if( ova_career_use_google_map.value == 'yes' ) {
            $('.ova_career_single #ova_career_admin_show_map').each(function(){
                var map = initMap( $(this) );
            });
        }

        // Single Career Gallery
        $('.ova_career_single .career_gallery').each(function(){
            Fancybox.bind('[data-fancybox="career-gallery-fancybox"]', {
                Image: {
                    zoom: false,
                },
            });
        });
 
        // Single Career Shortcode Apply button
        $('.career_single_container').each(function(){
            var that     = $(this);
            var btnApply = that.find('.button-apply');
            var modal    = that.find('.ova-career-modal');

            btnApply.on('click', function () {
                modal.slideDown();
            });

            $('body').click(function(e){
                if ( e.target == modal[0] ) {
                    modal.slideUp();
                }
            });
        });

   });

})(jQuery);