(function($){
	"use strict";

	$(window).on('elementor/frontend/init', function () {
		
		/* Masonry Element */
        elementorFrontend.hooks.addAction('frontend/element_ready/ova_collections.default', function(){
            $( document ).ready(function() {

                if($().imagesLoaded) {
                    var $grid = $('.archive_collection .content_archive_coll').imagesLoaded( function() {
                        $grid.masonry({
                            itemSelector: '.items_archive_coll',
                            columnWidth: '.items_archive_coll',
                            gutter: 30,
                            percentPosition: true
                        });
                    });
                }
                
            });
        });	

        /* Collections Slide */
        elementorFrontend.hooks.addAction('frontend/element_ready/ova_collections_slide.default', function(){
            $(".ova-collections-slide .content_archive_coll").each(function(){
                var owlsl = $(this) ;
                var owlsl_ops = owlsl.data('options') ? owlsl.data('options') : {};

                if ( $('body').hasClass('rtl') ) {
                    owlsl_ops.rtl = true;
                }

                var responsive_value = {
                    0:{
                        items:1
                    },
                    767:{
                        items:1
                    },
                    992:{
                        items:2
                    },
                    1170:{
                        items:owlsl_ops.items
                    }
               };
              
                owlsl.owlCarousel({
                    autoWidth: owlsl_ops.autoWidth,
                    margin: owlsl_ops.margin,
                    items: owlsl_ops.items,
                    loop: owlsl_ops.loop,
                    autoplay: owlsl_ops.autoplay,
                    autoplayTimeout: owlsl_ops.autoplayTimeout,
                    center: owlsl_ops.center,
                    nav: false,
                    dots: owlsl_ops.dots,
                    thumbs: owlsl_ops.thumbs,
                    autoplayHoverPause: owlsl_ops.autoplayHoverPause,
                    slideBy: owlsl_ops.slideBy,
                    smartSpeed: owlsl_ops.smartSpeed,
                    rtl : owlsl_ops.rtl,
                    navText:[
                        '<i class="fa fa-angle-left" ></i>',
                        '<i class="fa fa-angle-right" ></i>'
                    ],
                    responsive: responsive_value,
               });

                /* Fixed WCAG */
                owlsl.find(".owl-nav button.owl-prev").attr("title", "Previous");
                owlsl.find(".owl-nav button.owl-next").attr("title", "Next");
                owlsl.find(".owl-dots button").attr("title", "Dots");

            });
        });	

    });
})(jQuery);