<?php
namespace ova_collections_elementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class ova_collections_slide extends Widget_Base {


	public function get_name() {
		return 'ova_collections_slide';
	}

	public function get_title() {
		return esc_html__( 'Collection Slide', 'ova-collection' );
	}

	public function get_icon() {
		return 'eicon-slider-album';
	}

	public function get_categories() {
		return [ 'ovatheme_collections' ];
	}

	public function get_script_depends() {
		wp_enqueue_style( 'carousel', OVACOLL_PLUGIN_URI.'assets/libs/owl-carousel/assets/owl.carousel.min.css' );
		wp_enqueue_script( 'carousel', OVACOLL_PLUGIN_URI.'assets/libs/owl-carousel/owl.carousel.min.js', array('jquery'), false, true );
		wp_enqueue_script( 'script-elementor-coll');

		return [ '' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'ova-collections', OVACOLL_PLUGIN_URI.'assets/css/elementor/collections.css' );
		wp_enqueue_style( 'ovacoll-slide', OVACOLL_PLUGIN_URI.'assets/css/elementor/collections-slide.css' );	
		return [];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Content', 'ova-collection' ),
			]
		);
		$this->add_control(
			'colection_type',
			[
				'label' => esc_html__('Colection Type', 'ova-colection'),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'type1' => esc_html__('Type 1', 'ova-colection'),
					'type2' => esc_html__('Type 2', 'ova-colection')
				],
				'default' => 'type1'
			]
		);

		$this->add_control(
			'order_by',
			[
				'label'   => esc_html__( 'Order By', 'ova-colection' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'collection_custom_sort',
				'options' => [
					'title'                  => esc_html__( 'Title', 'ova-colection' ),
					'date'                   => esc_html__( 'Date', 'ova-colection' ),
					'collection_custom_sort' => esc_html__( 'Custom Sort', 'ova-colection' ),
					'ID'                     => esc_html__( 'ID', 'ova-colection' ),					
				],
			]
		);

		$this->add_control(
			'order',
			[
				'label'   => esc_html__( 'Order', 'ova-collection' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => [
					'DESC' => esc_html__( 'Descending', 'ova-collection' ),
					'ASC'  => esc_html__( 'Ascending', 'ova-collection' ),
				],

			]
		);

		$this->add_control(
			'total_count',
			[
				'label'   => esc_html__( 'Total Post', 'ova-collection' ),
				'type'    => Controls_Manager::NUMBER,
				'min'     => 1,
				'default' => 5
			]
		);

		$this->add_control(
			'filter_type',
			[
				'label' => esc_html__( 'Filter Type', 'ova-collection' ),
				'type' => Controls_Manager::TEXT,
				'description' => esc_html__( 'Insert Slug Type. Example: prints, photography', 'ova-collection' ),
				'default' => '',
			]
		);

		$this->add_control( 
			'show_year',
			[
				'label' => esc_html__( 'Show Year', 'ova-collection' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ova-collection' ),
				'label_off' => esc_html__( 'Hide', 'ova-collection' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control( 
			'show_type',
			[
				'label' => esc_html__( 'Show Type', 'ova-collection' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ova-collection' ),
				'label_off' => esc_html__( 'Hide', 'ova-collection' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control( 
			'show_title',
			[
				'label' => esc_html__( 'Show Title', 'ova-collection' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ova-collection' ),
				'label_off' => esc_html__( 'Hide', 'ova-collection' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control( 
			'show_artist',
			[
				'label' => esc_html__( 'Show Artist', 'ova-collection' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ova-collection' ),
				'label_off' => esc_html__( 'Hide', 'ova-collection' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
		$this->end_controls_section();

		/** Additional Options **/
		$this->start_controls_section(
			'section_additional_options',
			[
				'label' => esc_html__( 'Additional Options', 'ova-collection' ),
			]
		);

			$this->add_control(
				'margin_items',
				[
					'label'   => esc_html__( 'Margin Right Items', 'ova-collection' ),
					'type'    => Controls_Manager::NUMBER,
					'default' => 30,
				]
				
			);

			$this->add_control(
				'item_number',
				[
					'label'       => esc_html__( 'Item Number', 'ova-collection' ),
					'type'        => Controls_Manager::NUMBER,
					'description' => esc_html__( 'Number Item', 'ova-collection' ),
					'default'     => 3,
				]
			);
	

			$this->add_control(
				'slides_to_scroll',
				[
					'label'       => esc_html__( 'Slides to Scroll', 'ova-collection' ),
					'type'        => Controls_Manager::NUMBER,
					'description' => esc_html__( 'Set how many slides are scrolled per swipe.', 'ova-collection' ),
					'default'     => 1,
				]
			);

			$this->add_control(
				'pause_on_hover',
				[
					'label'   => esc_html__( 'Pause on Hover', 'ova-collection' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'ova-collection' ),
						'no'  => esc_html__( 'No', 'ova-collection' ),
					],
					'frontend_available' => true,
				]
			);


			$this->add_control(
				'infinite',
				[
					'label'   => esc_html__( 'Infinite Loop', 'ova-collection' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'ova-collection' ),
						'no'  => esc_html__( 'No', 'ova-collection' ),
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'autoplay',
				[
					'label'   => esc_html__( 'Autoplay', 'ova-collection' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'ova-collection' ),
						'no'  => esc_html__( 'No', 'ova-collection' ),
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'autoplay_speed',
				[
					'label'     => esc_html__( 'Autoplay Speed', 'ova-collection' ),
					'type'      => Controls_Manager::NUMBER,
					'default'   => 3000,
					'step'      => 500,
					'condition' => [
						'autoplay' => 'yes',
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'smartspeed',
				[
					'label'   => esc_html__( 'Smart Speed', 'ova-collection' ),
					'type'    => Controls_Manager::NUMBER,
					'default' => 500,
				]
			);

			$this->add_control(
				'dot_control',
				[
					'label'   => esc_html__( 'Show Dots', 'ova-collection' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'ova-collection' ),
						'no'  => esc_html__( 'No', 'ova-collection' ),
					],
					'frontend_available' => true,
				]
			);

		$this->end_controls_section();

		// Title style
		$this->start_controls_section(
			'section_title_style',
			[
				'label' => esc_html__( 'Title', 'ova-collection' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => esc_html__( 'Typography', 'ova-collection' ),
				'selector' => '{{WRAPPER}} .archive_collection .content_archive_coll .items_archive_coll .desc .title ',
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Title Color', 'ova-collection' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .archive_collection .content_archive_coll .items_archive_coll .desc .title a' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'title_hover_color',
			[
				'label' => esc_html__( 'Title Hover Color', 'ova-collection' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .archive_collection .content_archive_coll .items_archive_coll .desc .title a:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'title_magin',
			[
				'label' => esc_html__( 'Title Margin', 'ova-collection' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .archive_collection .content_archive_coll .items_archive_coll .desc .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_artists_style',
			[
				'label' => esc_html__( 'Artists', 'ova-collection' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'artists_typography',
				'label' => esc_html__( 'Typography', 'ova-collection' ),
				'selector' => '{{WRAPPER}} .archive_collection .content_archive_coll .items_archive_coll .desc .artists a',
			]
		);

		$this->add_control(
			'artists_color',
			[
				'label' => esc_html__( 'Artists Color', 'ova-collection' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .archive_collection .content_archive_coll .items_archive_coll .desc .artists a' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'artists_hover_color',
			[
				'label' => esc_html__( 'Artists Hover Color', 'ova-collection' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .archive_collection .content_archive_coll .items_archive_coll .desc .artists a:hover' => 'color: {{VALUE}};',
				],
			]
		);


		$this->end_controls_section();		

	}

	protected function render() {

		$settings = $this->get_settings();

		$collections_type 	= (!empty($settings['colection_type'])) ? $settings['colection_type'] : 'type1'; 

		$args_basic = array(
			'post_type'      => 'collection',
			'post_status'    => 'publish',
			'orderby'        => $settings['order_by'],
			'order'          => $settings['order'],
			'posts_per_page' => $settings['total_count']
		);

		if ( $settings['filter_type'] ) {
			$tax_query = array(
				'tax_query' => array(
					array(
						'taxonomy' => 'collection_type',
						'field' => 'slug',
						'terms' =>  explode(',', $settings['filter_type'])
					),
				),
			);
		} else {
			$tax_query = array();
		}
		
		$args = array_merge_recursive( $args_basic, $tax_query );
		
		$collections  = new \WP_Query($args); 

		$data_options['items']              = $settings['item_number'];
		$data_options['slideBy']            = $settings['slides_to_scroll'];
		$data_options['margin']             = $settings['margin_items'];
		$data_options['autoplayHoverPause'] = $settings['pause_on_hover'] === 'yes' ? true : false;
		$data_options['loop']               = $settings['infinite'] === 'yes' ? true : false;
		$data_options['autoplay']           = $settings['autoplay'] === 'yes' ? true : false;
		$data_options['autoplayTimeout']    = $settings['autoplay_speed'];
		$data_options['smartSpeed']         = $settings['smartspeed'];
		$data_options['dots']               = $settings['dot_control'] === 'yes' ? true : false;
		$data_options['rtl']				= is_rtl() ? true : false;

		// show fields
		$args_show = array(
			'show_year'   => $settings['show_year'],
			'show_type'   => $settings['show_type'],
			'show_title'  => $settings['show_title'],
			'show_artist' => $settings['show_artist'],
		);

		?>

		<div class="ova-collections-slide">

			<div class="content_archive_coll owl-carousel owl-theme <?php echo esc_attr($collections_type);?>" data-options="<?php echo esc_attr(json_encode($data_options)); ?>">

				<?php if($collections->have_posts() ) : while ( $collections->have_posts() ) : $collections->the_post();

					ovacoll_get_template( 'parts/item-collection.php', $args_show );

				endwhile;endif; wp_reset_postdata(); ?>
				
			</div>

		</div>

		<?php 
	}
}