<?php defined( 'ABSPATH' ) || exit();

if( !class_exists( 'OVADEP_assets' ) ){
	class OVADEP_assets{

		public function __construct(){
			add_action( 'wp_enqueue_scripts', array( $this, 'ovadep_enqueue_scripts' ), 10, 0 );
		}

		public function ovadep_enqueue_scripts(){

			if ( is_post_type_archive( 'ova_dep' ) || is_tax( 'cat_department' ) || is_singular( 'ova_dep' ) ){
				wp_enqueue_style( 'ovadep_style', OVADEP_PLUGIN_URI.'assets/css/frontend/ovadep-style.css' );
			}
			
			if ( is_post_type_archive( 'ova_dep' ) || is_tax( 'cat_department' ) ){
				// select2
				wp_enqueue_style( 'select2', OVADEP_PLUGIN_URI.'assets/libs/select2/select2.min.css', array(), null );
				wp_enqueue_script( 'select2', OVADEP_PLUGIN_URI.'assets/libs/select2/select2.min.js', array('jquery'), false, true );

				wp_enqueue_script( 'ovadep_js', OVADEP_PLUGIN_URI.'assets/js/frontend/ovadep-script.js' );	
				wp_localize_script( 'ovadep_js', 'Placeholder', array('name' => esc_html__( 'Name', 'ova-dep' )) );
			}

		}

	}
	new OVADEP_assets();
}
