<?php if ( !defined( 'ABSPATH' ) ) exit();

	$id_dep = $args['id_dep'];
	$id_dep = ! empty( $id_dep ) ? $id_dep : get_the_id();

	$list_file_deps = get_post_meta( $id_dep, 'ova_dep_met_list_file_dep', true );

	if(is_array($list_file_deps) && !empty($list_file_deps)) {
		$list_file_deps = array_reverse($list_file_deps);
	}
	
?>


	<?php if( ! empty( $list_file_deps ) ) { ?>

		<ul class="ova_dep_list_file">
			<?php foreach( $list_file_deps as $file_id => $file_dep ){

				$data = @file_get_contents($file_dep);

				$name_file 	= basename( $file_dep );
				$ext_file 	= pathinfo( $name_file, PATHINFO_EXTENSION );

				// Get post from $file_id
				$files = ova_dep_get_name_files( $file_id );
				if ( !empty( $files ) ) {
					foreach ($files as $file) {
						$name_file = $file->post_title ? $file->post_title : $file->post_excerpt;
					}
				}

				// Check empty $name_file
				if ( empty( $name_file ) ) {
					$name_file = basename( $file_dep );
				}

				?>

				<?php if( $data ) { ?>
					<li>
						<?php if($show_icon == 'yes') : ?>
							<span class="icon-attachment">
								<?php echo ova_dep_get_icon_attachment_file( $ext_file ) ?>
							</span>
						<?php endif; ?>

						<span class="file-name-size">
							<?php if($show_title == 'yes') : ?>
								<span class="file-name">
									<?php echo esc_html( $name_file ) ?>
								</span>
							<?php endif; ?>

							<?php if($show_file_size == 'yes') : ?>
								<span class="file-size">
									<span class="type">
										<?php echo esc_html( $ext_file ) ?>
									</span>
									<span class="file-size">
										(<?php echo ova_dep_get_file_size( $file_dep ) . esc_html__( 'kb', 'ova-dep' ) ?>)
									</span>
								</span>
							<?php endif; ?>
						</span>
						<span class="ova-download">
							<?php if($show_view_icon == 'yes') : ?>
								<a href="<?php echo esc_url( $file_dep ); ?>" class="view"
									target="_blank"
									title="<?php esc_attr_e( 'View', 'ova-dep' ); ?>">
									<i class="far fa-eye" aria-hidden="true"></i>
								</a>
							<?php endif; ?>

							<?php if($show_download_icon == 'yes') : ?>
								<a href="<?php echo esc_url( $file_dep ); ?>"
									title="<?php esc_attr_e( 'Download', 'ova-dep' ); ?>" download>
									<i class="gimonticon-download" aria-hidden="true"></i>
								</a>
							<?php endif; ?>
						</span>
					</li>
				<?php } ?>

				<?php } ?>
				
			</ul>

	<?php } ?>