<?php if ( !defined( 'ABSPATH' ) ) exit(); 

$get_search_cat  = isset( $_GET["ovadep_cat"] )  ? $_GET["ovadep_cat"]  : '';
$get_search_name = isset( $_GET["ovadep_name"] ) ? $_GET["ovadep_name"] : '';

if( is_tax( 'cat_department' ) ||  get_query_var( 'cat_department' ) != '' ){
	$get_search_cat = get_query_var( 'cat_department' );
}

$all_ids   = ova_dep_get_all_id();
$all_names = [];

foreach ($all_ids as $id ) {
	$all_names[$id] = get_the_title($id);
}

$show_search_name     = isset($args['show_search_name']) ? $args['show_search_name'] : 'yes';
$show_search_category = isset($args['show_search_category']) ? $args['show_search_category'] : 'yes';

?>

<div class="search_archive_department" data-names="<?php echo esc_attr(json_encode($all_names)); ?>">

	<form action="<?php echo esc_url(get_post_type_archive_link( 'ova_dep' )); ?>" method="GET" name="search_department" autocomplete="off">

		<?php if( $show_search_name == 'yes' ) : ?>
			<div class="dep-name">
				<label class="second_font ova-label-search visuallyhidden" for="ovadep_name">
					<?php esc_html_e('Name', 'ova-dep') ?>
				</label>
				
				<input 
					type="text" 
					id="ovadep_name" 
					class="ovadep_name" 
					placeholder="<?php echo esc_attr__( 'Name', 'ova-dep' ); ?>" 
					name="ovadep_name" 
					value="<?php echo esc_attr( $get_search_name ); ?>" 
				/>
			</div>
		<?php endif; ?>

		<?php if( $show_search_category == 'yes' ) : ?>
			<div class="ovadep_cat_search">
				<label class="ova-label-search visuallyhidden" for="ovadep_cat">
					<?php esc_html_e('Category', 'ova-dep'); ?>
				</label>

				<?php $ovadep_cat_dropdown = apply_filters( 'ovadep_cat_dropdown', $get_search_cat ); ?>
				<i class="arrow_carrot-down" aria-hidden="true"></i>
			</div>
		<?php endif; ?>

		<div class="wrap-ovadep_submit">
			<label class="visuallyhidden" for="ovadep_submit">
				<?php esc_html_e('Find Department', 'ova-dep'); ?>
			</label>

			<input class="ovadep_submit" id="ovadep_submit" name="ovadep_submit" type="submit" value="<?php esc_html_e('Find Department', 'ova-dep'); ?>" />
		</div>

		<input type="hidden" name="post_type" value="ova_dep">
		<input type="hidden" name="search_department" value="search-department">
		
	</form>

</div>