<?php
/*
Plugin Name: Ovatheme Directory
Plugin URI: https://themeforest.net/user/ovatheme
Description: Directory
Author: Ovatheme
Version: 1.0.6
Author URI: https://themeforest.net/user/ovatheme/portfolio
Text Domain: ova-dir
Domain Path: /languages/
*/

if ( !defined( 'ABSPATH' ) ) exit();


if (!class_exists('ovadir')) {
	
	class ovadir
	{
		static $_instance = null;

		function __construct()
		{
			$this -> define_constants();
			$this -> includes();
			$this -> supports();
		}

		function define_constants(){
			$this->define( 'OVADIR_PLUGIN_FILE', __FILE__ );
			$this->define( 'OVADIR_PLUGIN_URI', plugin_dir_url( __FILE__ ) );
			$this->define( 'OVADIR_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
			load_plugin_textdomain( 'ova-dir', false, basename( dirname( __FILE__ ) ) .'/languages' );
		}

		function define( $name, $value ) {
			if ( ! defined( $name ) ) {
				define( $name, $value );
			}
		}

		public static function instance() {
			if ( !empty( self::$_instance ) ) {
				return self::$_instance;
			}
			return self::$_instance = new self();
		}

		function includes() {

			// inc
			require_once( OVADIR_PLUGIN_PATH.'inc/class-ova-custom-post-type.php' );

			require_once( OVADIR_PLUGIN_PATH.'inc/class-ova-register-sidebar.php' );

			require_once( OVADIR_PLUGIN_PATH.'inc/class-ova-get-data.php' );

			require_once( OVADIR_PLUGIN_PATH.'inc/ova-core-functions.php' );
			
			require_once( OVADIR_PLUGIN_PATH.'inc/class-ova-templates-loaders.php' );

			require_once( OVADIR_PLUGIN_PATH.'inc/class-ova-assets.php' );

			require_once( OVADIR_PLUGIN_PATH.'inc/class-ova-ajax.php' );

			// admin
			require_once( OVADIR_PLUGIN_PATH.'admin/class-ova-metabox.php' );

			/* Customize */

			require_once OVADIR_PLUGIN_PATH.'/inc/class-customize.php';

		}


		function supports() {

			/* Make Elementors */
			if ( did_action( 'elementor/loaded' ) ) {
				include OVADIR_PLUGIN_PATH.'elementor/class-ova-register-elementor.php';
			}

		}

	}
}

function ovadir() {
	return ovadir::instance();
}

$GLOBALS['ovadir'] = ovadir();