(function($){
	"use strict";

	$(window).on('elementor/frontend/init', function () {

        elementorFrontend.hooks.addAction('frontend/element_ready/ova_doc_download_2.default', function(){

            var body    = $("body");
            var modal   = $(".ova-doc-download-2 .ova-doc-modal");
            var viewBtn = $(".ova-doc-download-2 .view");
            if (modal.length) {
                body.click(function(e){
                    if ( e.target == modal[0] ) {
                        modal.slideUp();
                    }
                });
                viewBtn.click(function(e){
                    e.preventDefault();
                    var loader = $(this).parent().find(".loader");
                    var docId = $(this).attr("data-id");
                    loader.addClass("is-active");
                    $.ajax({
                        type: "post",
                        dataType: "html",
                        url: ova_doc_ajax_object.ajax_url,
                        data: {
                            action: 'ova_show_file_list',
                            id: docId,
                        },
                        success: function(response){
                            modal.html(response);
                            modal.slideDown();
                            loader.removeClass("is-active");
                        }
                    });
                    
                });

                $(document).on('click', ".ova-doc-modal .close", function () {    
                    modal.slideUp();
                });
            }
        });

  });
})(jQuery);