<?php

if ( !defined( 'ABSPATH' ) ) {
	exit;
}

class OVADOC_templates_loader {
	
	/**
	 * The Constructor
	 */
	public function __construct() {
		add_filter( 'template_include', array( $this, 'template_loader' ) );
	}

	public function template_loader( $template ) {

		$post_type = isset($_REQUEST['post_type'] ) ? esc_html( $_REQUEST['post_type'] ) : get_post_type();


		if( is_tax( 'cat_doc' ) ||  get_query_var( 'cat_doc' ) != '' ){
			
			ovadoc_get_template( 'archive-doc.php' );
			return false;
		}


		// Is Team Post Type
		if(  $post_type == 'ova_doc' ){

			if ( is_post_type_archive( 'ova_doc' ) ) { 

				ovadoc_get_template( 'archive-doc.php' );
				return false;

			} else if ( is_single() ) {

				ovadoc_get_template( 'single-doc.php' );
				return false;

			}
		}


		if ( $post_type !== 'ova_doc' ){
			return $template;
		}

		
	}
}

new OVADOC_templates_loader();
