<?php
namespace ova_ovaev_elementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class ova_event_tabs extends Widget_Base {

	public function get_name() {		
		return 'ova_event_tabs';
	}

	public function get_title() {
		return esc_html__( 'Event Tabs', 'ovaev' );
	}

	public function get_icon() {
		return 'eicon-tabs';
	}

	public function get_categories() {
		return [ 'ovaev_template' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_tabs',
			[
				'label' => esc_html__( 'Tabs', 'ovaev' ),
			]
		);

			$this->add_control(
				'map_zoom',
				[
					'label' 	=> esc_html__( 'Map Zoom', 'ovaev' ),
					'type' 		=> Controls_Manager::NUMBER,
					'default' 	=> 17,
				]
			);

		$this->end_controls_section();

		$this->start_controls_section(
            'location_style',
            [
                'label' => esc_html__( 'Location', 'ovaev' ),
                'tab' 	=> Controls_Manager::TAB_STYLE,
            ]
        );

        	$this->add_responsive_control(
	            'content_margin',
	            [
	                'label' 		=> esc_html__( 'Margin', 'ovaev' ),
	                'type' 			=> Controls_Manager::DIMENSIONS,
	                'size_units' 	=> [ 'px', '%', 'em' ],
	                'selectors' 	=> [
	                    '{{WRAPPER}} .ovaev-event-tabs .content-event .tab-Location .tab-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
	                ],
	            ]
	        );

        	$this->add_responsive_control(
				'map_height',
				[
					'label' 	=> esc_html__( 'Map Height', 'ovaev' ),
					'type' 		=> Controls_Manager::SLIDER,
					'default' 	=> [
						'unit' 	=> 'px',
					],
					'tablet_default' => [
						'unit' => 'px',
					],
					'mobile_default' => [
						'unit' => 'px',
					],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'size_units' 	=> [ '%', 'px' ],
					'selectors' 	=> [
						'{{WRAPPER}} .ovaev-event-tabs .content-event .tab-Location .tab-content #location-tab-pane' => 'height: {{SIZE}}{{UNIT}} !important;',
					],
				]
			);

        $this->end_controls_section();
 

	}

	protected function render() {

		$settings 	= $this->get_settings();

		$id 		= get_the_ID();
		$post_type 	= get_post_type( $id );
		
		if ( empty( $post_type ) || 'event' != $post_type ) {
			echo '<div class="ovaev_elementor_none"><span>' . esc_html( $this->get_title() ) . '</span></div>';
			return;
		}

		$event_map_zoom    	= $settings['map_zoom'] ? $settings['map_zoom'] : 17;
		$event_map_address 	= get_post_meta( $id, 'ovaev_map_address', true );
		$event_map_lat 		= get_post_meta( $id, 'ovaev_map_lat', true );
		$event_map_lng     	= get_post_meta( $id, 'ovaev_map_lng', true );
		$event_name        	= get_post_meta( $id, 'ovaev_organizer', true);
		$event_phone       	= get_post_meta( $id, 'ovaev_phone', true);
		$event_email       	= get_post_meta( $id, 'ovaev_email', true);
		$event_website     	= get_post_meta( $id, 'ovaev_website', true);
		$event_gallery     	= get_post_meta( $id, 'ovaev_gallery_id', true);

		?>

		<?php if( ! empty( $event_map_address ) || ! empty( $event_ame ) || ! empty( $event_phone ) || ! empty( $event_email ) || ! empty( $event_website ) || ! empty( $event_gallery ) ): ?>
			<div class="ovaev-event-tabs single_event">		
				<div class="content-event">

					<div class="tab-Location">

						<div class="event_nav event_nav-tabs" role="tablist" aria-label="<?php echo esc_attr('Event Tabs','ovaev');?>">

							<?php if( ! empty( $event_map_address ) ) { ?>
							 	
						    	<button class="event_nav-link" id="ovaev-tab-location" data-href="#location-tab-pane"
						    		role="tab" aria-selected="true" aria-controls="location-tab-pane" tabindex="0"
						    	>
						    		<?php esc_html_e('Location','ovaev')?>
						    	</button>
							  	
							 <?php } ?>

						  	<?php if( ! empty( $event_name ) || ! empty( $event_phone ) || ! empty( $event_email ) || ! empty( $event_website ) ) { ?>
							  
						    	<button class="event_nav-link" id="ovaev-tab-contact" data-href="#contact-tab-pane" role="tab"
						    		aria-selected="false" aria-controls="contact-tab-pane" tabindex="-1"
						    	>
						    		<?php esc_html_e('Contact Details','ovaev')?>
						    	</button>
							 	
						 	<?php } ?>

						 	<?php if( $event_gallery != '' ){  ?>
							  
						    	<button class="event_nav-link" id="ovaev-tab-gallery" data-href="#gallery-tab-pane" role="tab"
						    		aria-selected="false" aria-controls="gallery-tab-pane" tabindex="-1"
						    	>
						    		<?php esc_html_e('Gallery','ovaev')?>
						    	</button>
							  	
						  	<?php } ?>

						</div>

						<!-- Tab panes -->
						<div class="tab-content">

							<?php if( ! empty( $event_map_address ) ) { ?>
					  			<div role="tabpanel" 
					  				class="event_tab-pane active" 
					  				id="location-tab-pane" 
					  				aria-labelledby="ovaev-tab-location"
					  				tabindex="0"
					  				style="height: 500px;" 
					  				data-address="<?php echo esc_attr($event_map_address);?>" 
					  				data-lat="<?php echo esc_attr($event_map_lat);?>" 
					  				data-lng="<?php echo esc_attr($event_map_lng);?>" 
					  				data-zoom="<?php echo esc_attr($event_map_zoom); ?>"
					  			></div>
						  	<?php } ?>
						  	
							<?php if( ! empty( $event_name ) || ! empty( $event_phone ) || ! empty( $event_email ) || ! empty( $event_website ) ) { ?>
						  		<div role="tabpanel" class="event_tab-pane" id="contact-tab-pane" aria-labelledby="ovaev-tab-contact" tabindex="0">
						  			<div class="event_row">
										<div class="col_contact">
											<div class="contact">
												<ul class="info-contact">
													<?php if( $event_name != '' ) : ?>
	 												<li>
														<span><?php esc_html_e('Organizer Name:','ovaev'); ?></span>
														<span class="info"><?php echo esc_html($event_name); ?></span>
													</li>
													<?php endif; ?>
													<?php if( $event_phone != '') : ?>
													<li>
														<span><?php esc_html_e('Phone:','ovaev'); ?></span>
														<a href="tel:<?php echo esc_attr( $event_phone ) ?>" class="info"><?php echo esc_html($event_phone); ?></a>
													</li>
													<?php endif; ?>
												</ul>
											</div>
										</div>
										<div class="col_contact">
											<div class="contact">
												<ul class="info-contact">
													<?php if( $event_email != '') : ?>
													<li>
														<span><?php esc_html_e('Email:','ovaev'); ?></span>
														<a href="mailto:<?php echo esc_attr( $event_email ) ?>" class="info"><?php echo esc_html($event_email); ?></a>
													</li>
													<?php endif; ?>
													<?php if( $event_website != '') : ?>
													<li>
														<span><?php esc_html_e('Website:','ovaev'); ?></span>
														<a href="<?php echo esc_url( $event_website ) ?>" class="info"><?php echo esc_html($event_website); ?></a>
													</li>
													<?php endif; ?>
												</ul>
											</div>
										</div>
						  			</div>
						  		</div>
					  		<?php } ?>


					  		<?php if( $event_gallery != '' ) :  ?>
					 		 	<div role="tabpanel" class="event_tab-pane" id="gallery-tab-pane" aria-labelledby="ovaev-tab-gallery" tabindex="0">
					 		 		<div class="event_row">
					 		 			<?php
					 		 			foreach ( $event_gallery as $items ) { ?>
					 		 				<div class="event_col-6">
												<div class="gallery-items">
													<?php
														$img_url = wp_get_attachment_image_url( $items, 'large' );
													?>
													<a href="<?php echo esc_url($img_url);?>" data-gal="prettyPhoto[gal]"><img src="<?php echo esc_url($img_url);?>"  alt="<?php echo get_the_title() ?>" /></a> 
												</div>
											</div>
					 		 			<?php }  ?>
					 		 		</div>
					 		 	</div>
			 		 		<?php endif; ?>
				 		 	
						</div>
					</div>

				</div>
			</div>
		<?php
		endif;
	}
}
