<?php if ( !defined( 'ABSPATH' ) ) exit(); 

	$version 		= $args['version'];
	$column_temp 	= $args['column_template'];
	$type_list 	    = $args['type_list'];
	$type_event 	= $args['type_event'];
	$text_read_more = $args['text_read_more'];
	$title 			= $args['title'] != '' ? esc_html( $args['title'] ) : '';

	$show_title 	= $args['show_title'] != '' ? esc_html( $args['show_title'] ) : '';
	$show_read_more = $args['show_read_more'] != '' ? esc_html( $args['show_read_more'] ) : '';

	$template_layout = $args['template1_style'];

	$events = ovaev_get_events_elements( $args );

	$args_show = array(
		'show_thumbnail'  => isset($args['show_thumbnail']) ? $args['show_thumbnail'] : 'yes',
		'show_date' 	  => isset($args['show_date']) ? $args['show_date'] : 'yes',
		'show_hour' 	  => isset($args['show_hour']) ? $args['show_hour'] : 'yes',
		'show_location'   => isset($args['show_location']) ? $args['show_location'] : 'yes',
		'show_title' 	  => isset($args['show_event_title']) ? $args['show_event_title'] : 'yes',
		'show_short_desc' => isset($args['show_short_desc']) ? $args['show_short_desc'] : 'yes',
		'show_link_to' 	  => isset($args['show_link_to']) ? $args['show_link_to'] : 'yes',
	);

?>

<div class="ovaev-event-element <?php echo esc_attr( $version ) ?>" >

	<?php if( $show_title == 'yes' && $version == 'version_1' ) { ?>
		<h2 class="title-event">
			<?php echo esc_html($title); ?>
		</h2>
	<?php } ?>

	<?php if( ( $show_title == 'yes' || $show_read_more == 'yes' ) && ( $title != '' || $text_read_more != '' ) && ( $version == 'version_2') ) { ?>
		<div class="title-readmore">
			<?php if( $show_title == 'yes' ) { ?>
				<h2 class="title-event">
					<?php echo esc_html($title); ?>
				</h2>
			<?php } ?>

			<?php if( $show_read_more == 'yes' ){ ?>
				<a href="<?php echo get_post_type_archive_link('event'); ?>" class="read-more second_font">
					<?php echo esc_html( $text_read_more ); ?>
				</a>
			<?php } ?>
		</div>
	<?php } ?>


	<?php if ( $version == 'version_1' ) { 
		if( $events->have_posts() ) : while( $events->have_posts() ) : $events->the_post();
			echo ovaev_get_template( 'elements/__content_list.php', array( 'type_list' => $type_list, 'args_show' => $args_show ) );
		endwhile; endif; wp_reset_postdata();
	} else { ?>

		<div class="container-event">
			<div id="main-event" class="content-event">
				<div class="archive_event <?php echo esc_attr( $column_temp ); ?> <?php echo esc_attr( $template_layout ); ?>">

					<?php if( $events->have_posts() ) : while( $events->have_posts() ) : $events->the_post(); ?>
						<?php ovaev_get_template( 'event-templates/event-'.$type_event.'.php', $args_show ); ?>
					<?php endwhile; else: ?>
						<div class="search_not_found">
							<?php esc_html_e( 'No Events found', 'ovaev' ); ?>
						</div>
					<?php endif; wp_reset_postdata(); ?>

				</div>
			</div>
		</div>

	<?php } ?>

</div>