<?php if ( !defined( 'ABSPATH' ) ) exit();

if ( !class_exists( 'OVAEX_custom_post_type' ) ) {
	
	class OVAEX_custom_post_type{

		public function __construct(){
			add_action( 'init', array( $this, 'OVAEX_register_post_type_exhibition' ) );
			add_action( 'init', array( $this, 'OVAEX_register_taxonomy_type_exhibition' ) );

			// Change submenu location of custom taxonomies
			add_action( 'submenu_file', array( $this, 'ovaex_submenu_file' ) );
			add_action( 'parent_file', array( $this, 'ovaex_parent_file' ) );
		}

		function OVAEX_register_post_type_exhibition() {

			$taxonomies = array( 'cat_exhibition' );

			$labels = array(
				'name'                  => _x( 'Exhibitions', 'Post Type General Name', 'ovaex' ),
				'singular_name'         => _x( 'Exhibition', 'Post Type Singular Name', 'ovaex' ),
				'menu_name'             => __( 'Exhibitions', 'ovaex' ),
				'name_admin_bar'        => __( 'Exhibition', 'ovaex' ),
				'archives'              => __( 'Item Archives', 'ovaex' ),
				'attributes'            => __( 'Item Attributes', 'ovaex' ),
				'parent_item_colon'     => __( 'Parent Item:', 'ovaex' ),
				'all_items'             => __( 'All Exhibitions', 'ovaex' ),
				'add_new_item'          => __( 'Add New Exhibition', 'ovaex' ),
				'add_new'               => __( 'Add New Exhibition', 'ovaex' ),
				'new_item'              => __( 'New Item', 'ovaex' ),
				'edit_item'             => __( 'Edit Exhibition', 'ovaex' ),
				'view_item'             => __( 'View Item', 'ovaex' ),
				'view_items'            => __( 'View Items', 'ovaex' ),
				'search_items'          => __( 'Search Item', 'ovaex' ),
				'not_found'             => __( 'Not found', 'ovaex' ),
				'not_found_in_trash'    => __( 'Not found in Trash', 'ovaex' ),
			);

			$args = array(
				'description'         => __( 'Post Type Description', 'ovaex' ),
				'labels'              => $labels,
				'supports'            => array( 'author', 'title', 'editor', 'comments', 'excerpt', 'thumbnail' ),
				'taxonomies'          => $taxonomies,
				'hierarchical'        => false,
				'public'              => true,
				'show_ui'             => true,
				'show_in_menu'        => 'ovaex-menu',
				'show_in_rest'        => true,
				'menu_position'       => 35,
				'query_var'           => true,
				'has_archive'         => true,
				'exclude_from_search' => true,
				'publicly_queryable'  => true,
				'rewrite'             => array( 'slug' => _x( 'exhibition', 'URL slug', 'ovaex' ) ),
				'capability_type'     => 'post',
			);

			register_post_type( 'exhibition', $args );
		}

		function OVAEX_register_taxonomy_type_exhibition() {
			$labels = array(
				'name'                       => _x( 'Categories', 'Post Type General Name', 'ovaex' ),
				'singular_name'              => _x( 'Category', 'Post Type Singular Name', 'ovaex' ),
				'menu_name'                  => __( 'Categories', 'ovaex' ),
				'all_items'                  => __( 'All', 'ovaex' ),
				'parent_item'                => __( 'Parent Item', 'ovaex' ),
				'parent_item_colon'          => __( 'Parent Item:', 'ovaex' ),
				'new_item_name'              => __( 'New Item Name', 'ovaex' ),
				'add_new_item'               => __( 'Add New', 'ovaex' ),
				'add_new'                    => __( 'Add New', 'ovaex' ),
				'edit_item'                  => __( 'Edit Category', 'ovaex' ),
				'view_item'                  => __( 'View Item', 'ovaex' ),
				'separate_items_with_commas' => __( 'Separate items with commas', 'ovaex' ),
				'add_or_remove_items'        => __( 'Add or remove items', 'ovaex' ),
				'choose_from_most_used'      => __( 'Choose from the most used', 'ovaex' ),
				'popular_items'              => __( 'Popular Items', 'ovaex' ),
				'search_items'               => __( 'Search Items', 'ovaex' ),
				'not_found'                  => __( 'Not Found', 'ovaex' ),
				'no_terms'                   => __( 'No items', 'ovaex' ),
				'items_list'                 => __( 'Items list', 'ovaex' ),
				'items_list_navigation'      => __( 'Items list navigation', 'ovaex' ),
			);

			$args = array(
				'labels'            	=> $labels,
				'hierarchical'      	=> true,
				'publicly_queryable'	=> true,
				'public'            	=> true,
				'show_ui'           	=> true,
				'show_admin_column' 	=> true,
				'show_in_nav_menus' 	=> true,
				'show_in_rest'        	=> true,
				'show_tagcloud'     	=> false,
				'rewrite'           	=> array(
					'slug'       => _x( 'cat_exhibition','Category Exhibition Slug', 'ovaex' ),
					'with_front' => false,
					'feeds'      => true,
				),
			);

			register_taxonomy( 'cat_exhibition', array( 'exhibition' ), $args );
		}

		/**
		 * Change submenu location of custom taxonomies: get it into menu ovaex-menu
		 */
		function ovaex_submenu_file( $submenu_file ) {
		    switch( get_current_screen()->taxonomy ) {
		        case 'cat_exhibition':
		            $submenu_file = 'edit-tags.php?taxonomy=cat_exhibition'.'&post_type=exhibition';
		            break;
		    }
		    return $submenu_file;
		}

		function ovaex_parent_file( $parent_file ) {
		    switch( get_current_screen()->taxonomy ) {
		        case 'cat_exhibition':
		            $parent_file = 'ovaex-menu';
		            break;
		    }
		    return $parent_file;
		}
	}

	new OVAEX_custom_post_type();
}