<?php
/**
 * Include and setup custom metaboxes and fields. (make sure you copy this file to outside the CMB2 directory)
 *
 * Be sure to replace all instances of 'yourprefix_' with your project's prefix.
 * http://nacin.com/2010/05/11/in-wordpress-prefix-everything/
 *
 * @category YourThemeOrPlugin
 * @package  Demo_CMB2
 * @license  http://www.opensource.org/licenses/gpl-license.php GPL v2.0 (or later)
 * @link     https://github.com/WebDevStudios/CMB2
 */



add_action( 'cmb2_init', 'ova_por_metaboxes' );
function ova_por_metaboxes() {

    // Start with an underscore to hide fields from custom fields list
    $prefix = 'ova_por_met_';
    
    $por_settings = new_cmb2_box( array(
        'id'            => 'ovapor_settings',
        'title'         => esc_html__( 'Portfolio settings', 'ova-por' ),
        'object_types'  => array( 'ova_por'), // Post type
        'context'       => 'normal',
        'priority'      => 'high',
        'show_names'    => true,
        
    ) );

        $por_settings->add_field( array(
            'name'       => esc_html__( 'Gallery', 'ova-por' ),
            'id'         => $prefix . 'gallery',
            'type'    => 'file_list',
        ) );


        $por_settings->add_field( array(
            'name'       => esc_html__( 'Date', 'ova-por' ),
            'id'         => $prefix . 'date',
            'type'    => 'text_date',
        ) );

        $por_settings->add_field( array(
            'name'       => esc_html__( 'Location', 'ova-por' ),
            'id'         => $prefix . 'location',
            'type'    => 'text',
        ) );

         $por_settings->add_field( array(
            'name'       => esc_html__( 'Department', 'ova-por' ),
            'id'         => $prefix . 'department',
            'type'    => 'text',
        ) );

         $por_settings->add_field( array(
            'name'       => esc_html__( 'Sort Order', 'ova-por' ),
            'id'         => $prefix . 'order_por',
            'desc' => esc_html__( 'Insert Number', 'ova-por' ),
            'type'    => 'text',
            'default' =>'1',
        ) );
}
