(function($){
	"use strict";

	$(window).on('elementor/frontend/init', function () {

        elementorFrontend.hooks.addAction('frontend/element_ready/ova_por_gallery.default', function(){
            $('.ova-por-gallery').each( function() {

                $('.ova-por-gallery .icon').on("click",function(){
                    var gallery = JSON.parse( $(this).attr("data-gallery") );
                    new Fancybox(gallery,{
                        'scrolling': 'no',
                        'speedIn': 600, 
                        'speedOut': 200, 
                        'overlayShow' : false,
                        caption: function (fancybox, carousel, slide) {
                            return (
                                `${slide.index + 1} / ${carousel.slides.length} <br />` + slide.caption
                            );
                        },
                    });
                });

            });
        });
        
    });
})(jQuery);