<?php

if ( !defined( 'ABSPATH' ) ) {
	exit;
}

class Ova_get_data {

	public function __construct() {
		add_action('wp_ajax_ova_loadmore_portfolio', array( $this, 'ova_loadmore_portfolio' ), 10 , 0 );
		add_action('wp_ajax_nopriv_ova_loadmore_portfolio', array( $this, 'ova_loadmore_portfolio' ), 10, 0 );

		add_action('wp_ajax_ova_por_category_desc', array( $this, 'ova_por_category_desc' ) );
		add_action('wp_ajax_nopriv_ova_por_category_desc', array( $this, 'ova_por_category_desc' ) );

	}

	public function ova_loadmore_portfolio(){
		$paged     	= isset( $_POST['paged'] ) ? sanitize_text_field( $_POST['paged'] ) : 1;
		$perpage   	= isset( $_POST['perpage'] ) ? sanitize_text_field( $_POST['perpage'] ) : 6;
		$cat 		= isset( $_POST['cat'] ) ? sanitize_text_field( $_POST['cat'] ) : 0;
		$type 		= isset( $_POST['type'] ) ? sanitize_text_field( $_POST['type'] ) : '';

		$orderby 	= get_theme_mod( 'ova_por_orderby', 'sort_order' );
		$order 		= get_theme_mod( 'ova_por_order', 'ASC' );

		$args = array(
		    'post_type'   		=> 'ova_por',
		    'posts_per_page' 	=> $perpage,
		    'paged'          	=> $paged,
		    'post_status' 		=> array( 'publish' ),
		    'order' 			=> $order,
		);

		if ( $cat != 0 ) {
			$args['tax_query'] = array(
		        array(
		            'taxonomy' => 'cat_por',
		            'field'    => 'id',
		            'terms'    => $cat, 
		        ),
		    );
		}
		
		if ( $orderby === 'sort_order' ) {
			$args['orderby'] 	= 'meta_value_num';
			$args['meta_type'] 	= 'NUMERIC';
			$args['meta_key'] 	= 'ova_por_met_order_por';
		} else {
			$args['orderby'] 	= $orderby;
		}

		$list_portfolios = get_posts( $args );

		if ( $list_portfolios ) {			
			foreach ( $list_portfolios as $portfolio ) {
				$id 		= $portfolio->ID;
				$url_img 	= get_the_post_thumbnail_url( $id, 'ova_por_thumbnail' );
				$title 		= get_the_title( $id );
				$link 		= get_the_permalink( $id );
				$cat_por 	= get_cat_id_por_by_id_por( $id );
				$gallery 	= get_post_meta( $id, 'ova_por_met_gallery', true );
		?>
			<div class="ovapor-item <?php echo esc_attr( $cat_por ); ?> ">
				<?php if ( $type == 'classic_porfolio' ) { ?>
					<div class="ovapor-item-sub-content">
				<?php } ?>
				<?php if ( $url_img ) { ?>
					<a href="<?php echo esc_url( $link ); ?>" >
						<?php if ( ! empty( $gallery ) ){ ?>
							<span class="number-gallery">
								<?php echo count( $gallery ) ?>
							</span>
						<?php } ?>
						<img src="<?php echo esc_url( $url_img ) ?>" alt="<?php echo $title ?>">
					</a>
					<div class="content-item">
						<div class="category">
							<?php get_category_por_by_id_por( $id ); ?>
						</div>
						<h2 class="title">
							<a class="second_font" href="<?php echo esc_url( $link ); ?>">
								<?php echo esc_html( wp_strip_all_tags( $title ) ); ?>
							</a>
						</h2>
						<div class="readmore">
							<a href="<?php echo esc_url( $link ); ?>">
								<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-arrow-right"><line x1="5" y1="12" x2="19" y2="12"></line><polyline points="12 5 19 12 12 19"></polyline></svg>
							</a>
						</div>
					</div>
				<?php } ?>
				<?php if( $type == 'classic_porfolio' ) { ?>
				</div>
				<?php } ?>
			</div>
			<?php 
			} 
			wp_reset_postdata(); 
		} else {
			echo '';
			wp_die();
		}
		wp_die();
	}

	public function ova_por_category_desc(){
		$id = intval( $_POST['id'] );
		ob_start();
		?>
		<?php
		echo category_description($id);
		echo ob_get_clean();
		wp_die();
	}
}

new Ova_get_data();