<?php

if ( !defined( 'ABSPATH' ) ) {
	exit;
}

function get_portfolio_related_by_id( $id_por ){

	$terms_cat = get_the_terms( $id_por, 'cat_por' );

    $arr_cat = [];
    if( $terms_cat ){
        foreach( $terms_cat as $cat ){
            $arr_cat[] = $cat->term_id;
        }
    }
	$args_related = array(
        'post_type' => 'ova_por',
        'posts_per_page' => 3,
        'post__not_in' => array( $id_por ),
        'tax_query' => array(
            array(
                'taxonomy' => 'cat_por',
                'field'    => 'term_id',
                'terms'    => $arr_cat,
            ),
        ),
    );
    $portfolio_related = get_posts( $args_related );

	?>

	<?php if( $portfolio_related ){ ?>

		<div class="wrap-related-por">
			<div class="related-por-inner">
				<h3 class="title-related">
					<?php esc_html_e( 'Related Projects', 'ova-por' ) ?>
				</h3>
				<div class="related-por">
					<?php foreach( $portfolio_related as $related ){ 
						$id = $related->ID;

						$url_img 	= get_the_post_thumbnail_url( $id, 'ova_por_thumbnail' );
						$title 		= get_the_title( $id );
						$link 		= get_the_permalink( $id );
						$cat_por 	= get_cat_id_por_by_id_por( $id );
						$gallery 	= get_post_meta( $id, 'ova_por_met_gallery', true );

						?>
						
						<div class="ovapor-item <?php echo esc_attr( $cat_por ); ?>">
							<?php if( $url_img ){ ?>
								<a href="<?php echo esc_url( $link ); ?>">
									<?php if( ! empty( $gallery ) ){ ?>
									<span class="number-gallery">
										<?php echo count( $gallery ); ?>
									</span>
									<?php } ?>
									<img src="<?php echo esc_url( $url_img ); ?>" alt="<?php echo esc_html($title);?>">
								</a>

								<div class="content-item">
									<div class="category">
										<?php get_category_por_by_id_por( $id ) ?>
									</div>
									<h2 class="title">
										<a class="second_font" href="<?php echo esc_url($link); ?>">
											<?php echo esc_html($title); ?>
										</a>
									</h2>
									<div class="readmore">
										<a href="<?php echo esc_url($link); ?>" aria-label="<?php esc_attr_e('View Portfolio','ova-por');?>">
											<i class="ovaicon-next"></i>
										</a>
									</div>
								</div>
							
							<?php } ?>
						</div>
					<?php } ?>
					
				</div>
			</div>
		</div>

	<?php }  
	wp_reset_postdata();
}

add_action( 'pre_get_posts', 'ova_por_post_per_page_archive' );

function ova_por_post_per_page_archive( $query ) {

	if ( ! is_admin() && $query->is_main_query() ) {

		if ( is_post_type_archive( 'ova_por' ) || is_tax('cat_por') ) {

			if( $query->is_post_type_archive( 'ova_por' ) || $query->is_tax('cat_por') ) {

				$query->set('post_type', array( 'ova_por' ) );
				$query->set('posts_per_page', get_theme_mod( 'ova_por_total_record', 60 ) );

				$orderby 	= get_theme_mod( 'ova_por_orderby', 'sort_order' );
				$order 		= get_theme_mod( 'ova_por_order', 'ASC' );

				$query->set('order', $order );

				if ( $orderby === 'sort_order' ) {
					$query->set('orderby', 'meta_value_num' );
					$query->set('meta_type', 'NUMERIC' );
		        	$query->set('meta_key', 'ova_por_met_order_por' );
				} else {
					$query->set('orderby', $orderby );
				}

			}

		}
	}
}

function get_category_por_by_id_por( $id = '' ){

	if( $id === '' ) return;

	$cat_pors = get_the_terms( $id, 'cat_por' );
	$i = 0;

	if( ! empty( $cat_pors ) ){
		$count_cat = count( $cat_pors );

		foreach ($cat_pors as $cat_por) {
			$i++;
			$separator = ( $count_cat !== $i ) ? "," : "";

			$link = get_term_link($cat_por->term_id);
			$name = $cat_por->name;
			?>
				<span class="cat-por">
					<a href="<?php echo esc_url( $link ) ?>"><?php echo esc_html( $name ) ?></a>
				</span>
				<span class="separator">
					<?php echo esc_html( $separator ) ?>
				</span>

			<?php
		}
	}
}

function get_cat_id_por_by_id_por( $id_por = '' ){

	if( $id_por === '' ) return;

	$cat_pors = get_the_terms( $id_por, 'cat_por' );
	$i = 0;

	$cat_id = '';
	if( ! empty( $cat_pors ) ){
		$count_cat = count( $cat_pors );
		foreach ($cat_pors as $cat_por) {
			$i++;
			$separator = ( $count_cat !== $i ) ? " " : "";

			$name = $cat_por->name;
			$term_id = $cat_por->term_id;

			$cat_id .= $term_id  . $separator;
		}
	}

	return $cat_id;
}

function ova_por_query($args) {

	$order 			= $args['order'];
	$order_by 		= $args['order_by'];
	$posts_per_page = $args['posts_per_page'];
	$cate 			= $args['cate'];

	$wp_args = array(
		'post_type' 		=> 'ova_por',
		'post_status' 		=> 'publish',
		'order' 			=> $order,
		'orderby' 			=> $order_by,
		'posts_per_page' 	=> $posts_per_page,
	);

	if ( $order_by == 'ova_doc_met_order_por' ) {
		$wp_args['orderby'] 	= 'meta_value_num';
		$wp_args['meta_key'] 	= $order_by;
		$wp_args['meta_type'] 	= 'NUMERIC';
	}

	if ($cate != 'all') {
		$wp_args['tax_query'] = array(
			array(
				'taxonomy'         => 'cat_por',
				'field'            => 'slug',
				'terms'            => $cate,
				'include_children' => true,
				'operator'         => 'IN',
			),
		);
	}

	return new WP_Query( $wp_args );
}

function ova_por_show_icon( $mime_type = '' ){
	if ( $mime_type == 'video/mp4' ): ?>
		<i class="gimonticon gimonticon gimonticon-video"></i>
	<?php else: ?>
		<i class="gimonticon gimonticon-image-gallery"></i>
	<?php endif;
}